// EpromDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HIDClient.h"
#include "EpromDlg.h"
#include "HIDClientDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEpromDlg dialog


CEpromDlg::CEpromDlg(bool internal, CWnd* pParent /*=NULL*/)
	: CDialog(CEpromDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEpromDlg)
	m_strMin1 = _T("00");
	m_strMin2 = _T("00");
	m_strMin3 = _T("00");
	m_strMin4 = _T("00");
	m_strMin5 = _T("00");
	m_strSec1 = _T("00");
	m_strSec2 = _T("00");
	m_strSec3 = _T("00");
	m_strSec4 = _T("00");
	m_strSec5 = _T("00");
	m_strLine11 = _T("");
	m_strLine12 = _T("");
	m_strLine21 = _T("");
	m_strLine22 = _T("");
	m_strLine31 = _T("");
	m_strLine32 = _T("");
	m_strLine41 = _T("");
	m_strLine42 = _T("");
	m_strLine51 = _T("");
	m_strLine52 = _T("");
	m_disable1 = FALSE;
	m_disable2 = FALSE;
	m_disable3 = FALSE;
	m_disable4 = FALSE;
	m_disable5 = FALSE;
	m_fulltime1 = FALSE;
	m_fulltime2 = FALSE;
	m_fulltime3 = FALSE;
	m_fulltime4 = FALSE;
	m_fulltime5 = FALSE;
	m_blight1 = FALSE;
	m_blight2 = FALSE;
	m_blight3 = FALSE;
	m_blight4 = FALSE;
	m_blight5 = FALSE;
	m_led1_1 = FALSE;
	m_led1_2 = FALSE;
	m_led1_3 = FALSE;
	m_led1_4 = FALSE;
	m_led1_5 = FALSE;
	m_led2_1 = FALSE;
	m_led2_2 = FALSE;
	m_led2_3 = FALSE;
	m_led2_4 = FALSE;
	m_led2_5 = FALSE;
	m_led3_1 = FALSE;
	m_led3_2 = FALSE;
	m_led3_3 = FALSE;
	m_led3_4 = FALSE;
	m_led3_5 = FALSE;
	m_led4_1 = FALSE;
	m_led4_2 = FALSE;
	m_led4_3 = FALSE;
	m_led4_4 = FALSE;
	m_led4_5 = FALSE;
	m_led5_1 = FALSE;
	m_led5_2 = FALSE;
	m_led5_3 = FALSE;
	m_led5_4 = FALSE;
	m_led5_5 = FALSE;
	m_leda_1 = FALSE;
	m_leda_2 = FALSE;
	m_leda_3 = FALSE;
	m_leda_4 = FALSE;
	m_leda_5 = FALSE;
	m_nNextSlot_1 = 0;
	m_nNextSlot_2 = 0;
	m_nNextSlot_3 = 0;
	m_nNextSlot_4 = 0;
	m_nNextSlot_5 = 0;
	m_nRepeat_1 = 0;
	m_nRepeat_2 = 0;
	m_nRepeat_3 = 0;
	m_nRepeat_4 = 0;
	m_nRepeat_5 = 0;
	//}}AFX_DATA_INIT

	m_bInternal = internal;
}


void CEpromDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEpromDlg)
	DDX_Text(pDX, IDC_EDIT_MIN1, m_strMin1);
	DDX_Text(pDX, IDC_EDIT_MIN2, m_strMin2);
	DDX_Text(pDX, IDC_EDIT_MIN3, m_strMin3);
	DDX_Text(pDX, IDC_EDIT_MIN4, m_strMin4);
	DDX_Text(pDX, IDC_EDIT_MIN5, m_strMin5);
	DDX_Text(pDX, IDC_EDIT_SEC1, m_strSec1);
	DDX_Text(pDX, IDC_EDIT_SEC2, m_strSec2);
	DDX_Text(pDX, IDC_EDIT_SEC3, m_strSec3);
	DDX_Text(pDX, IDC_EDIT_SEC4, m_strSec4);
	DDX_Text(pDX, IDC_EDIT_SEC5, m_strSec5);
	DDX_Text(pDX, IDC_LINE11, m_strLine11);
	DDV_MaxChars(pDX, m_strLine11, 20);
	DDX_Text(pDX, IDC_LINE12, m_strLine12);
	DDV_MaxChars(pDX, m_strLine12, 20);
	DDX_Text(pDX, IDC_LINE21, m_strLine21);
	DDV_MaxChars(pDX, m_strLine21, 20);
	DDX_Text(pDX, IDC_LINE22, m_strLine22);
	DDV_MaxChars(pDX, m_strLine22, 20);
	DDX_Text(pDX, IDC_LINE31, m_strLine31);
	DDV_MaxChars(pDX, m_strLine31, 20);
	DDX_Text(pDX, IDC_LINE32, m_strLine32);
	DDV_MaxChars(pDX, m_strLine32, 20);
	DDX_Text(pDX, IDC_LINE41, m_strLine41);
	DDV_MaxChars(pDX, m_strLine41, 20);
	DDX_Text(pDX, IDC_LINE42, m_strLine42);
	DDV_MaxChars(pDX, m_strLine42, 20);
	DDX_Text(pDX, IDC_LINE51, m_strLine51);
	DDV_MaxChars(pDX, m_strLine51, 20);
	DDX_Text(pDX, IDC_LINE52, m_strLine52);
	DDV_MaxChars(pDX, m_strLine52, 20);
	DDX_Check(pDX, IDC_CHECK_DISABLE1, m_disable1);
	DDX_Check(pDX, IDC_CHECK_DISABLE2, m_disable2);
	DDX_Check(pDX, IDC_CHECK_DISABLE3, m_disable3);
	DDX_Check(pDX, IDC_CHECK_DISABLE4, m_disable4);
	DDX_Check(pDX, IDC_CHECK_DISABLE5, m_disable5);
	DDX_Check(pDX, IDC_CHECK_FULLTIME1, m_fulltime1);
	DDX_Check(pDX, IDC_CHECK_FULLTIME2, m_fulltime2);
	DDX_Check(pDX, IDC_CHECK_FULLTIME3, m_fulltime3);
	DDX_Check(pDX, IDC_CHECK_FULLTIME4, m_fulltime4);
	DDX_Check(pDX, IDC_CHECK_FULLTIME5, m_fulltime5);
	DDX_Check(pDX, IDC_CHECK_BLIGHT1, m_blight1);
	DDX_Check(pDX, IDC_CHECK_BLIGHT2, m_blight2);
	DDX_Check(pDX, IDC_CHECK_BLIGHT3, m_blight3);
	DDX_Check(pDX, IDC_CHECK_BLIGHT4, m_blight4);
	DDX_Check(pDX, IDC_CHECK_BLIGHT5, m_blight5);
	DDX_Check(pDX, IDC_CHECK_L1_1, m_led1_1);
	DDX_Check(pDX, IDC_CHECK_L1_2, m_led1_2);
	DDX_Check(pDX, IDC_CHECK_L1_3, m_led1_3);
	DDX_Check(pDX, IDC_CHECK_L1_4, m_led1_4);
	DDX_Check(pDX, IDC_CHECK_L1_5, m_led1_5);
	DDX_Check(pDX, IDC_CHECK_L2_1, m_led2_1);
	DDX_Check(pDX, IDC_CHECK_L2_2, m_led2_2);
	DDX_Check(pDX, IDC_CHECK_L2_3, m_led2_3);
	DDX_Check(pDX, IDC_CHECK_L2_4, m_led2_4);
	DDX_Check(pDX, IDC_CHECK_L2_5, m_led2_5);
	DDX_Check(pDX, IDC_CHECK_L3_1, m_led3_1);
	DDX_Check(pDX, IDC_CHECK_L3_2, m_led3_2);
	DDX_Check(pDX, IDC_CHECK_L3_3, m_led3_3);
	DDX_Check(pDX, IDC_CHECK_L3_4, m_led3_4);
	DDX_Check(pDX, IDC_CHECK_L3_5, m_led3_5);
	DDX_Check(pDX, IDC_CHECK_L4_1, m_led4_1);
	DDX_Check(pDX, IDC_CHECK_L4_2, m_led4_2);
	DDX_Check(pDX, IDC_CHECK_L4_3, m_led4_3);
	DDX_Check(pDX, IDC_CHECK_L4_4, m_led4_4);
	DDX_Check(pDX, IDC_CHECK_L4_5, m_led4_5);
	DDX_Check(pDX, IDC_CHECK_L5_1, m_led5_1);
	DDX_Check(pDX, IDC_CHECK_L5_2, m_led5_2);
	DDX_Check(pDX, IDC_CHECK_L5_3, m_led5_3);
	DDX_Check(pDX, IDC_CHECK_L5_4, m_led5_4);
	DDX_Check(pDX, IDC_CHECK_L5_5, m_led5_5);
	DDX_Check(pDX, IDC_CHECK_LA_1, m_leda_1);
	DDX_Check(pDX, IDC_CHECK_LA_2, m_leda_2);
	DDX_Check(pDX, IDC_CHECK_LA_3, m_leda_3);
	DDX_Check(pDX, IDC_CHECK_LA_4, m_leda_4);
	DDX_Check(pDX, IDC_CHECK_LA_5, m_leda_5);
	DDX_Text(pDX, IDC_EDIT_NS1, m_nNextSlot_1);
	DDV_MinMaxInt(pDX, m_nNextSlot_1, 0, 10);
	DDX_Text(pDX, IDC_EDIT_NS2, m_nNextSlot_2);
	DDV_MinMaxInt(pDX, m_nNextSlot_2, 0, 10);
	DDX_Text(pDX, IDC_EDIT_NS3, m_nNextSlot_3);
	DDV_MinMaxInt(pDX, m_nNextSlot_3, 0, 10);
	DDX_Text(pDX, IDC_EDIT_NS4, m_nNextSlot_4);
	DDV_MinMaxInt(pDX, m_nNextSlot_4, 0, 10);
	DDX_Text(pDX, IDC_EDIT_NS5, m_nNextSlot_5);
	DDV_MinMaxInt(pDX, m_nNextSlot_5, 0, 10);
	DDX_Text(pDX, IDC_EDIT_REP1, m_nRepeat_1);
	DDV_MinMaxInt(pDX, m_nRepeat_1, 0, 255);
	DDX_Text(pDX, IDC_EDIT_REP2, m_nRepeat_2);
	DDV_MinMaxInt(pDX, m_nRepeat_2, 0, 255);
	DDX_Text(pDX, IDC_EDIT_REP3, m_nRepeat_3);
	DDV_MinMaxInt(pDX, m_nRepeat_3, 0, 255);
	DDX_Text(pDX, IDC_EDIT_REP4, m_nRepeat_4);
	DDV_MinMaxInt(pDX, m_nRepeat_4, 0, 255);
	DDX_Text(pDX, IDC_EDIT_REP5, m_nRepeat_5);
	DDV_MinMaxInt(pDX, m_nRepeat_5, 0, 255);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEpromDlg, CDialog)
	//{{AFX_MSG_MAP(CEpromDlg)
	ON_BN_CLICKED(IDC_BUTTON_UPLOAD, OnButtonUpload)
	ON_BN_CLICKED(IDC_CHECK_DISABLE1, OnCheckDisable1)
	ON_BN_CLICKED(IDC_CHECK_DISABLE2, OnCheckDisable2)
	ON_BN_CLICKED(IDC_CHECK_DISABLE3, OnCheckDisable3)
	ON_BN_CLICKED(IDC_CHECK_DISABLE4, OnCheckDisable4)
	ON_BN_CLICKED(IDC_CHECK_DISABLE5, OnCheckDisable5)
	ON_BN_CLICKED(IDC_CHECK_FULLTIME1, OnCheckFulltime1)
	ON_BN_CLICKED(IDC_CHECK_FULLTIME2, OnCheckFulltime2)
	ON_BN_CLICKED(IDC_CHECK_FULLTIME3, OnCheckFulltime3)
	ON_BN_CLICKED(IDC_CHECK_FULLTIME4, OnCheckFulltime4)
	ON_BN_CLICKED(IDC_CHECK_FULLTIME5, OnCheckFulltime5)
	ON_BN_CLICKED(IDC_BUTTON_TEST, OnButtonTestSplash)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEpromDlg message handlers

void CEpromDlg::OnButtonUpload() 
{
	if (m_bInternal)
		 ((CHIDClientDlg*)AfxGetMainWnd())->sendToSocket("get inte");
	else ((CHIDClientDlg*)AfxGetMainWnd())->sendToSocket("get exte");
}

void CEpromDlg::SetMin(int i, CString str)
{
	switch (i)
	{
	case 0:m_strMin1 = str;break;
	case 1:m_strMin2 = str;break;
	case 2:m_strMin3 = str;break;
	case 3:m_strMin4 = str;break;
	case 4:m_strMin5 = str;break;
	}

	UpdateData(FALSE);
}

void CEpromDlg::SetSec(int i, CString str)
{
	switch (i)
	{
	case 0:m_strSec1 = str;break;
	case 1:m_strSec2 = str;break;
	case 2:m_strSec3 = str;break;
	case 3:m_strSec4 = str;break;
	case 4:m_strSec5 = str;break;
	}
	UpdateData(FALSE);
}

void CEpromDlg::SetAdditionalInfo(int i, unsigned long led, unsigned long nextslot, unsigned long repetition)
{
	switch (i)
	{
	case 0:
		{
			if (led & 0x80) m_blight1 = true;else m_blight1=false; 
			//0x40 unused
			if (led & 0x20) m_led5_1 = true;else m_led5_1=false;
			if (led & 0x10) m_led4_1 = true;else m_led4_1=false;
			if (led & 0x08) m_led3_1 = true;else m_led3_1=false;
			if (led & 0x04) m_led2_1 = true;else m_led2_1=false;
			if (led & 0x02) m_led1_1 = true;else m_led1_1=false;
			if (led & 0x01) m_leda_1 = true;else m_leda_1=false;

			m_nNextSlot_1 = nextslot;
			m_nRepeat_1 = repetition;
		}break;
	case 1:
		{
			if (led & 0x80) m_blight2 = true;else m_blight2=false; 
			//0x40 unused
			if (led & 0x20) m_led5_2 = true;else m_led5_2=false;
			if (led & 0x10) m_led4_2 = true;else m_led4_2=false;
			if (led & 0x08) m_led3_2 = true;else m_led3_2=false;
			if (led & 0x04) m_led2_2 = true;else m_led2_2=false;
			if (led & 0x02) m_led1_2 = true;else m_led1_2=false;
			if (led & 0x01) m_leda_2 = true;else m_leda_2=false;

			m_nNextSlot_2 = nextslot;
			m_nRepeat_2 = repetition;
		}break;
	case 2:
		{
			if (led & 0x80) m_blight3 = true;else m_blight3=false; 
			//0x40 unused
			if (led & 0x20) m_led5_3 = true;else m_led5_3=false;
			if (led & 0x10) m_led4_3 = true;else m_led4_3=false;
			if (led & 0x08) m_led3_3 = true;else m_led3_3=false;
			if (led & 0x04) m_led2_3 = true;else m_led2_3=false;
			if (led & 0x02) m_led1_3 = true;else m_led1_3=false;
			if (led & 0x01) m_leda_3 = true;else m_leda_3=false;

			m_nNextSlot_3 = nextslot;
			m_nRepeat_3 = repetition;
		}break;
	case 3:
		{
			if (led & 0x80) m_blight4 = true;else m_blight4=false; 
			//0x40 unused
			if (led & 0x20) m_led5_4 = true;else m_led5_4=false;
			if (led & 0x10) m_led4_4 = true;else m_led4_4=false;
			if (led & 0x08) m_led3_4 = true;else m_led3_4=false;
			if (led & 0x04) m_led2_4 = true;else m_led2_4=false;
			if (led & 0x02) m_led1_4 = true;else m_led1_4=false;
			if (led & 0x01) m_leda_4 = true;else m_leda_4=false;

			m_nNextSlot_4 = nextslot;
			m_nRepeat_4 = repetition;
		}break;
	case 4:
		{
			if (led & 0x80) m_blight5 = true;else m_blight5=false; 
			//0x40 unused
			if (led & 0x20) m_led5_5 = true;else m_led5_5=false;
			if (led & 0x10) m_led4_5 = true;else m_led4_5=false;
			if (led & 0x08) m_led3_5 = true;else m_led3_5=false;
			if (led & 0x04) m_led2_5 = true;else m_led2_5=false;
			if (led & 0x02) m_led1_5 = true;else m_led1_5=false;
			if (led & 0x01) m_leda_5 = true;else m_leda_5=false;

			m_nNextSlot_5 = nextslot;
			m_nRepeat_5 = repetition;
		}break;
	}
	UpdateData(FALSE);	
}

CString CEpromDlg::GetLeds(int i)
{
	unsigned long led = 0;

	switch (i)
	{
	case 0:
		{
			if (m_blight1) led |= 0x80; 
			//0x40 unused
			if (m_led5_1)  led |= 0x20;
			if (m_led4_1)  led |= 0x10;
			if (m_led3_1)  led |= 0x08;
			if (m_led2_1)  led |= 0x04;
			if (m_led1_1)  led |= 0x02;
			if (m_leda_1)  led |= 0x01;
		}break;
	case 1:
		{
			if (m_blight2) led |= 0x80; 
			//0x40 unused
			if (m_led5_2)  led |= 0x20;
			if (m_led4_2)  led |= 0x10;
			if (m_led3_2)  led |= 0x08;
			if (m_led2_2)  led |= 0x04;
			if (m_led1_2)  led |= 0x02;
			if (m_leda_2)  led |= 0x01;
		}break;
	case 2:
		{
			if (m_blight3) led |= 0x80; 
			//0x40 unused
			if (m_led5_3)  led |= 0x20;
			if (m_led4_3)  led |= 0x10;
			if (m_led3_3)  led |= 0x08;
			if (m_led2_3)  led |= 0x04;
			if (m_led1_3)  led |= 0x02;
			if (m_leda_3)  led |= 0x01;
		}break;
	case 3:
		{
			if (m_blight4) led |= 0x80; 
			//0x40 unused
			if (m_led5_4)  led |= 0x20;
			if (m_led4_4)  led |= 0x10;
			if (m_led3_4)  led |= 0x08;
			if (m_led2_4)  led |= 0x04;
			if (m_led1_4)  led |= 0x02;
			if (m_leda_4)  led |= 0x01;
		}break;
	case 4:
		{
			if (m_blight5) led |= 0x80; 
			//0x40 unused
			if (m_led5_5)  led |= 0x20;
			if (m_led4_5)  led |= 0x10;
			if (m_led3_5)  led |= 0x08;
			if (m_led2_5)  led |= 0x04;
			if (m_led1_5)  led |= 0x02;
			if (m_leda_5)  led |= 0x01;
		}break;
	}

	CString str;str.Format("%02x", led & 0xFF);
	return str;
}

void CEpromDlg::SetLine1(int i, CString str)
{
	str.TrimRight(" ");
	switch (i)
	{
	case 0:m_strLine11 = str;break;
	case 1:m_strLine21 = str;break;
	case 2:m_strLine31 = str;break;
	case 3:m_strLine41 = str;break;
	case 4:m_strLine51 = str;break;
	}
	UpdateData(FALSE);
}

void CEpromDlg::SetLine2(int i, CString str)
{
	str.TrimRight(" ");
	switch (i)
	{
	case 0:m_strLine12 = str;break;
	case 1:m_strLine22 = str;break;
	case 2:m_strLine32 = str;break;
	case 3:m_strLine42 = str;break;
	case 4:m_strLine52 = str;break;
	}
	UpdateData(FALSE);
}

void CEpromDlg::CheckTime(int i)
{
	switch (i)
	{
	case 0:
		{
			int min = atoi(m_strMin1);int sec = atoi(m_strSec1);
			if ((min == 0) && (sec == 0))
			{
				m_strMin1 = "00";
				m_strSec1 = "01";
				
				m_disable1 = TRUE;
			}
			else m_disable1 = FALSE;

			if ((min == -1) || (sec == -1))
			{
				m_strMin1 = "00";
				m_strSec1 = "01";
				
				m_fulltime1 = TRUE;
			}
			else m_fulltime1 = FALSE;

			if (m_disable1 || m_fulltime1)
			{
				GetDlgItem(IDC_EDIT_MIN1)->EnableWindow(FALSE);
				GetDlgItem(IDC_EDIT_SEC1)->EnableWindow(FALSE);
			}
			else
			{
				GetDlgItem(IDC_EDIT_MIN1)->EnableWindow(TRUE);
				GetDlgItem(IDC_EDIT_SEC1)->EnableWindow(TRUE);
			}
		}break;
	case 1:
		{
			int min = atoi(m_strMin2);int sec = atoi(m_strSec2);
			if ((min == 0) && (sec == 0))
			{
				m_strMin2 = "00";
				m_strSec2 = "01";
				
				m_disable2 = TRUE;
			}
			else m_disable2 = FALSE;

			if ((min == -1) || (sec == -1))
			{
				m_strMin2 = "00";
				m_strSec2 = "01";
				
				m_fulltime2 = TRUE;
			}
			else m_fulltime2 = FALSE;

			if (m_disable2 || m_fulltime2)
			{
				GetDlgItem(IDC_EDIT_MIN2)->EnableWindow(FALSE);
				GetDlgItem(IDC_EDIT_SEC2)->EnableWindow(FALSE);
			}
			else
			{
				GetDlgItem(IDC_EDIT_MIN2)->EnableWindow(TRUE);
				GetDlgItem(IDC_EDIT_SEC2)->EnableWindow(TRUE);
			}
		}break;
	case 2:
		{
			int min = atoi(m_strMin3);int sec = atoi(m_strSec3);
			if ((min == 0) && (sec == 0))
			{
				m_strMin3 = "00";
				m_strSec3 = "01";
				
				m_disable3 = TRUE;
			}
			else m_disable3 = FALSE;

			if ((min == -1) || (sec == -1))
			{
				m_strMin3 = "00";
				m_strSec3 = "01";
				
				m_fulltime3 = TRUE;
			}
			else m_fulltime3 = FALSE;

			if (m_disable3 || m_fulltime3)
			{
				GetDlgItem(IDC_EDIT_MIN3)->EnableWindow(FALSE);
				GetDlgItem(IDC_EDIT_SEC3)->EnableWindow(FALSE);
			}
			else
			{
				GetDlgItem(IDC_EDIT_MIN3)->EnableWindow(TRUE);
				GetDlgItem(IDC_EDIT_SEC3)->EnableWindow(TRUE);
			}
		}break;
	case 3:
		{
			int min = atoi(m_strMin4);int sec = atoi(m_strSec4);
			if ((min == 0) && (sec == 0))
			{
				m_strMin4 = "00";
				m_strSec4 = "01";
				
				m_disable4 = TRUE;
			}
			else m_disable4 = FALSE;

			if ((min == -1) || (sec == -1))
			{
				m_strMin4 = "00";
				m_strSec4 = "01";
				
				m_fulltime4 = TRUE;
			}
			else m_fulltime4 = FALSE;

			if (m_disable4 || m_fulltime4)
			{
				GetDlgItem(IDC_EDIT_MIN4)->EnableWindow(FALSE);
				GetDlgItem(IDC_EDIT_SEC4)->EnableWindow(FALSE);
			}
			else
			{
				GetDlgItem(IDC_EDIT_MIN4)->EnableWindow(TRUE);
				GetDlgItem(IDC_EDIT_SEC4)->EnableWindow(TRUE);
			}
		}break;
	case 4:
		{
			int min = atoi(m_strMin5);int sec = atoi(m_strSec5);
			if ((min == 0) && (sec == 0))
			{
				m_strMin5 = "00";
				m_strSec5 = "01";
				
				m_disable5 = TRUE;
			}
			else m_disable5 = FALSE;

			if ((min == -1) || (sec == -1))
			{
				m_strMin5 = "00";
				m_strSec5 = "01";
				
				m_fulltime5 = TRUE;
			}
			else m_fulltime5 = FALSE;

			if (m_disable5 || m_fulltime5)
			{
				GetDlgItem(IDC_EDIT_MIN5)->EnableWindow(FALSE);
				GetDlgItem(IDC_EDIT_SEC5)->EnableWindow(FALSE);
			}
			else
			{
				GetDlgItem(IDC_EDIT_MIN5)->EnableWindow(TRUE);
				GetDlgItem(IDC_EDIT_SEC5)->EnableWindow(TRUE);
			}
		}break;
	}

	UpdateData(FALSE);
}

void CEpromDlg::OnCheckDisable1() 
{
	UpdateData(TRUE);
	if (m_disable1)
	{
		m_fulltime1 = FALSE;

		GetDlgItem(IDC_EDIT_MIN1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC1)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN1)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC1)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckDisable2() 
{
	UpdateData(TRUE);
	if (m_disable2)
	{
		m_fulltime2 = FALSE;

		GetDlgItem(IDC_EDIT_MIN2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC2)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN2)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC2)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckDisable3() 
{
	UpdateData(TRUE);
	if (m_disable3)
	{
		m_fulltime3 = FALSE;

		GetDlgItem(IDC_EDIT_MIN3)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC3)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN3)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC3)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckDisable4() 
{
	UpdateData(TRUE);
	if (m_disable4)
	{
		m_fulltime4 = FALSE;

		GetDlgItem(IDC_EDIT_MIN4)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC4)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN4)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC4)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckDisable5() 
{
	UpdateData(TRUE);
	if (m_disable5)
	{
		m_fulltime5 = FALSE;

		GetDlgItem(IDC_EDIT_MIN5)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC5)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN5)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC5)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckFulltime1() 
{
	UpdateData(TRUE);
	if (m_fulltime1)
	{
		m_disable1 = FALSE;

		GetDlgItem(IDC_EDIT_MIN1)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC1)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN1)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC1)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckFulltime2() 
{
	UpdateData(TRUE);
	if (m_fulltime2)
	{
		m_disable2 = FALSE;

		GetDlgItem(IDC_EDIT_MIN2)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC2)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN2)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC2)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckFulltime3() 
{
	UpdateData(TRUE);
	if (m_fulltime3)
	{
		m_disable3 = FALSE;

		GetDlgItem(IDC_EDIT_MIN3)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC3)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN3)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC3)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckFulltime4() 
{
	UpdateData(TRUE);
	if (m_fulltime4)
	{
		m_disable4 = FALSE;

		GetDlgItem(IDC_EDIT_MIN4)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC4)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN4)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC4)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnCheckFulltime5() 
{
	UpdateData(TRUE);
	if (m_fulltime5)
	{
		m_disable5 = FALSE;

		GetDlgItem(IDC_EDIT_MIN5)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SEC5)->EnableWindow(FALSE);
	}
	else
	{
		GetDlgItem(IDC_EDIT_MIN5)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SEC5)->EnableWindow(TRUE);
	}
	
	UpdateData(FALSE);
}

void CEpromDlg::OnOK() 
{
	UpdateData(TRUE);

	if (m_disable1) {m_strMin1 = "00";m_strSec1 = "00";}
	if (m_disable2) {m_strMin2 = "00";m_strSec2 = "00";}
	if (m_disable3) {m_strMin3 = "00";m_strSec3 = "00";}
	if (m_disable4) {m_strMin4 = "00";m_strSec4 = "00";}
	if (m_disable5) {m_strMin5 = "00";m_strSec5 = "00";}

	if (m_fulltime1){m_strMin1 = "-1";m_strSec1 = "-1";}
	if (m_fulltime2){m_strMin2 = "-1";m_strSec2 = "-1";}
	if (m_fulltime3){m_strMin3 = "-1";m_strSec3 = "-1";}
	if (m_fulltime4){m_strMin4 = "-1";m_strSec4 = "-1";}
	if (m_fulltime5){m_strMin5 = "-1";m_strSec5 = "-1";}

	UpdateData(FALSE);
	
	//CDialog::OnOK();

	CHIDClientDlg* pDlg = (CHIDClientDlg*)AfxGetMainWnd();
	if (m_bInternal)
	{
		CString str = "set inte "
			+ pDlg->getNo(m_strMin1)+"|"+pDlg->getNo(m_strSec1)+"|"
			+ pDlg->getInt(m_nNextSlot_1)+"|"+pDlg->getInt(m_nRepeat_1)+"|"+GetLeds(0)+"|"
			+ pDlg->fillString(m_strLine11,20)+"|"+pDlg->fillString(m_strLine12,20)+"|"
			+ pDlg->getNo(m_strMin2)+"|"+pDlg->getNo(m_strSec2)+"|"
			+ pDlg->getInt(m_nNextSlot_2)+"|"+pDlg->getInt(m_nRepeat_2)+"|"+GetLeds(1)+"|"
			+ pDlg->fillString(m_strLine21,20)+"|"+pDlg->fillString(m_strLine22,20)+"|"
			+ pDlg->getNo(m_strMin3)+"|"+pDlg->getNo(m_strSec3)+"|"
			+ pDlg->getInt(m_nNextSlot_3)+"|"+pDlg->getInt(m_nRepeat_3)+"|"+GetLeds(2)+"|"
			+ pDlg->fillString(m_strLine31,20)+"|"+pDlg->fillString(m_strLine32,20)+"|"
			+ pDlg->getNo(m_strMin4)+"|"+pDlg->getNo(m_strSec4)+"|"
			+ pDlg->getInt(m_nNextSlot_4)+"|"+pDlg->getInt(m_nRepeat_4)+"|"+GetLeds(3)+"|"
			+ pDlg->fillString(m_strLine41,20)+"|"+pDlg->fillString(m_strLine42,20)+"|"
			+ pDlg->getNo(m_strMin5)+"|"+pDlg->getNo(m_strSec5)+"|"
			+ pDlg->getInt(m_nNextSlot_5)+"|"+pDlg->getInt(m_nRepeat_5)+"|"+GetLeds(4)+"|"
			+ pDlg->fillString(m_strLine51,20)+"|"+pDlg->fillString(m_strLine52,20);

		
		pDlg->sendToSocket(str);
	}
	else
	{
		CString str = "set exte "
			+ pDlg->getNo(m_strMin1)+"|"+pDlg->getNo(m_strSec1)+"|"
			+ pDlg->getInt(m_nNextSlot_1)+"|"+pDlg->getInt(m_nRepeat_1)+"|"+GetLeds(0)+"|"
			+ pDlg->fillString(m_strLine11,20)+"|"+pDlg->fillString(m_strLine12,20)+"|"
			+ pDlg->getNo(m_strMin2)+"|"+pDlg->getNo(m_strSec2)+"|"
			+ pDlg->getInt(m_nNextSlot_2)+"|"+pDlg->getInt(m_nRepeat_2)+"|"+GetLeds(1)+"|"
			+ pDlg->fillString(m_strLine21,20)+"|"+pDlg->fillString(m_strLine22,20)+"|"
			+ pDlg->getNo(m_strMin3)+"|"+pDlg->getNo(m_strSec3)+"|"
			+ pDlg->getInt(m_nNextSlot_3)+"|"+pDlg->getInt(m_nRepeat_3)+"|"+GetLeds(2)+"|"
			+ pDlg->fillString(m_strLine31,20)+"|"+pDlg->fillString(m_strLine32,20)+"|"
			+ pDlg->getNo(m_strMin4)+"|"+pDlg->getNo(m_strSec4)+"|"
			+ pDlg->getInt(m_nNextSlot_4)+"|"+pDlg->getInt(m_nRepeat_4)+"|"+GetLeds(3)+"|"
			+ pDlg->fillString(m_strLine41,20)+"|"+pDlg->fillString(m_strLine42,20)+"|"
			+ pDlg->getNo(m_strMin5)+"|"+pDlg->getNo(m_strSec5)+"|"
			+ pDlg->getInt(m_nNextSlot_5)+"|"+pDlg->getInt(m_nRepeat_5)+"|"+GetLeds(4)+"|"
			+ pDlg->fillString(m_strLine51,20)+"|"+pDlg->fillString(m_strLine52,20);

		pDlg->sendToSocket(str);
	}

	AfxMessageBox("Splash content download initiated!");
}

BOOL CEpromDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if (m_bInternal)
	{
		SetWindowText("Splash screens (1-5)");
		SetDlgItemText(IDC_STATIC_SCREEN1, "Screen 1");
		SetDlgItemText(IDC_STATIC_SCREEN2, "Screen 2");
		SetDlgItemText(IDC_STATIC_SCREEN3, "Screen 3");
		SetDlgItemText(IDC_STATIC_SCREEN4, "Screen 4");
		SetDlgItemText(IDC_STATIC_SCREEN5, "Screen 5");
	}
	else 
	{
		SetWindowText("Splash screens (6-10)");
		SetDlgItemText(IDC_STATIC_SCREEN1, "Screen 6");
		SetDlgItemText(IDC_STATIC_SCREEN2, "Screen 7");
		SetDlgItemText(IDC_STATIC_SCREEN3, "Screen 8");
		SetDlgItemText(IDC_STATIC_SCREEN4, "Screen 9");
		SetDlgItemText(IDC_STATIC_SCREEN5, "Screen 10");
	}

	OnButtonUpload();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEpromDlg::OnButtonTestSplash() 
{
	((CHIDClientDlg*)AfxGetMainWnd())->sendToSocket("set splash");
}
