// HIDClientDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HIDClient.h"
#include "HIDClientDlg.h"
#include "LoginDlg.h"
#include "EpromDlg.h"
#include "RelayDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define STR_LINE_LEN	57

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHIDClientDlg dialog

CHIDClientDlg::CHIDClientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHIDClientDlg::IDD, pParent),
	  m_Socket(this)
{
	//{{AFX_DATA_INIT(CHIDClientDlg)
	m_bBacklight = FALSE;
	m_bLed1 = FALSE;
	m_bLed2 = FALSE;
	m_bLed3 = FALSE;
	m_bLed4 = FALSE;
	m_bLed5 = FALSE;
	m_bLed6 = FALSE;
	m_bLed7 = FALSE;
	m_bLed8 = FALSE;
	m_nFont = 0;
	m_strLine1 = _T("");
	m_strLine2 = _T("");
	m_nSlider = 0x40;
	m_bCursorBlink = FALSE;
	m_bCursorOn = FALSE;
	m_bLCDOn = TRUE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_dlgEpromInt = NULL;
	m_dlgEpromExt = NULL;
}

void CHIDClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHIDClientDlg)
	DDX_Control(pDX, IDC_SLIDER_CONTRAST, m_Slider);
	DDX_Control(pDX, IDC_LIST_KEY, m_listKey);
	DDX_Control(pDX, IDC_LIST_IR, m_listIR);
	DDX_Check(pDX, IDC_CHECK_BLIGHT, m_bBacklight);
	DDX_Check(pDX, IDC_CHECK_LED1, m_bLed1);
	DDX_Check(pDX, IDC_CHECK_LED2, m_bLed2);
	DDX_Check(pDX, IDC_CHECK_LED3, m_bLed3);
	DDX_Check(pDX, IDC_CHECK_LED4, m_bLed4);
	DDX_Check(pDX, IDC_CHECK_LED5, m_bLed5);
	DDX_Check(pDX, IDC_CHECK_LED6, m_bLed6);
	DDX_Check(pDX, IDC_CHECK_LED7, m_bLed7);
	DDX_Check(pDX, IDC_CHECK_LED8, m_bLed8);
	DDX_CBIndex(pDX, IDC_COMBO_FONT, m_nFont);
	DDX_Text(pDX, IDC_EDIT_DISPLAY, m_strLine1);
	DDX_Text(pDX, IDC_EDIT_DISPLAY2, m_strLine2);
	DDX_Slider(pDX, IDC_SLIDER_CONTRAST, m_nSlider);
	DDX_Control(pDX, IDC_CHECK_FONT11, m_Font11);
	DDX_Control(pDX, IDC_CHECK_FONT12, m_Font12);
	DDX_Control(pDX, IDC_CHECK_FONT13, m_Font13);
	DDX_Control(pDX, IDC_CHECK_FONT14, m_Font14);
	DDX_Control(pDX, IDC_CHECK_FONT15, m_Font15);
	DDX_Control(pDX, IDC_CHECK_FONT16, m_Font16);
	DDX_Control(pDX, IDC_CHECK_FONT17, m_Font17);
	DDX_Control(pDX, IDC_CHECK_FONT18, m_Font18);
	DDX_Control(pDX, IDC_CHECK_FONT21, m_Font21);
	DDX_Control(pDX, IDC_CHECK_FONT22, m_Font22);
	DDX_Control(pDX, IDC_CHECK_FONT23, m_Font23);
	DDX_Control(pDX, IDC_CHECK_FONT24, m_Font24);
	DDX_Control(pDX, IDC_CHECK_FONT25, m_Font25);
	DDX_Control(pDX, IDC_CHECK_FONT26, m_Font26);
	DDX_Control(pDX, IDC_CHECK_FONT27, m_Font27);
	DDX_Control(pDX, IDC_CHECK_FONT28, m_Font28);
	DDX_Control(pDX, IDC_CHECK_FONT31, m_Font31);
	DDX_Control(pDX, IDC_CHECK_FONT32, m_Font32);
	DDX_Control(pDX, IDC_CHECK_FONT33, m_Font33);
	DDX_Control(pDX, IDC_CHECK_FONT34, m_Font34);
	DDX_Control(pDX, IDC_CHECK_FONT35, m_Font35);
	DDX_Control(pDX, IDC_CHECK_FONT36, m_Font36);
	DDX_Control(pDX, IDC_CHECK_FONT37, m_Font37);
	DDX_Control(pDX, IDC_CHECK_FONT38, m_Font38);
	DDX_Control(pDX, IDC_CHECK_FONT41, m_Font41);
	DDX_Control(pDX, IDC_CHECK_FONT42, m_Font42);
	DDX_Control(pDX, IDC_CHECK_FONT43, m_Font43);
	DDX_Control(pDX, IDC_CHECK_FONT44, m_Font44);
	DDX_Control(pDX, IDC_CHECK_FONT45, m_Font45);
	DDX_Control(pDX, IDC_CHECK_FONT46, m_Font46);
	DDX_Control(pDX, IDC_CHECK_FONT47, m_Font47);
	DDX_Control(pDX, IDC_CHECK_FONT48, m_Font48);
	DDX_Control(pDX, IDC_CHECK_FONT51, m_Font51);
	DDX_Control(pDX, IDC_CHECK_FONT52, m_Font52);
	DDX_Control(pDX, IDC_CHECK_FONT53, m_Font53);
	DDX_Control(pDX, IDC_CHECK_FONT54, m_Font54);
	DDX_Control(pDX, IDC_CHECK_FONT55, m_Font55);
	DDX_Control(pDX, IDC_CHECK_FONT56, m_Font56);
	DDX_Control(pDX, IDC_CHECK_FONT57, m_Font57);
	DDX_Control(pDX, IDC_CHECK_FONT58, m_Font58);
	DDX_Check(pDX, IDC_CHECK_CURSORBLINK, m_bCursorBlink);
	DDX_Check(pDX, IDC_CHECK_CURSORONOFF, m_bCursorOn);
	DDX_Check(pDX, IDC_CHECK_LCDONOFF, m_bLCDOn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHIDClientDlg, CDialog)
	//{{AFX_MSG_MAP(CHIDClientDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_SEND1, OnButtonSend1)
	ON_BN_CLICKED(IDC_BUTTON_SEND2, OnButtonSend2)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_BN_CLICKED(IDC_CHECK_BLIGHT, OnCheckBlight)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_CONTRAST, OnReleasedcaptureSliderContrast)
	ON_BN_CLICKED(IDC_CHECK_LED1, OnCheckLed1)
	ON_BN_CLICKED(IDC_CHECK_LED2, OnCheckLed2)
	ON_BN_CLICKED(IDC_CHECK_LED3, OnCheckLed3)
	ON_BN_CLICKED(IDC_CHECK_LED4, OnCheckLed4)
	ON_BN_CLICKED(IDC_CHECK_LED5, OnCheckLed5)
	ON_BN_CLICKED(IDC_CHECK_LED6, OnCheckLed6)
	ON_BN_CLICKED(IDC_CHECK_LED7, OnCheckLed7)
	ON_BN_CLICKED(IDC_CHECK_LED8, OnCheckLed8)
	ON_BN_CLICKED(IDC_BUTTON_FONT, OnButtonFont)
	ON_BN_CLICKED(IDC_BUTTON_EPROM, OnButtonEprom)
	ON_BN_CLICKED(IDC_CHECK_CURSORBLINK, OnCheckCursorBlink)
	ON_BN_CLICKED(IDC_CHECK_CURSORONOFF, OnCheckCursorOnoff)
	ON_BN_CLICKED(IDC_CHECK_LCDONOFF, OnCheckLcdOnoff)
	ON_BN_CLICKED(IDC_BUTTON_RELAY, OnButtonRelay)
	ON_BN_CLICKED(IDC_BUTTON_EPROM2, OnButtonEprom2)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER, MyUpdate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHIDClientDlg message handlers
BOOL CHIDClientDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_Slider.SetRangeMin(0, TRUE);
	m_Slider.SetRangeMax(0x40, TRUE);
	
	CLoginDlg dlg(this);
	if (dlg.DoModal() == IDOK)
	{
		m_Socket.Connect(dlg.m_strHost, dlg.m_nPort);
		CString con;con.Format("%s:%d",dlg.m_strHost, dlg.m_nPort);
		if (m_Socket.isConnected())
		{
			 SetWindowText("Connected to "+ con);
			 m_Socket.start();
		}
		else
		{
			AfxMessageBox("Could not connect to "+con);
			EndDialog(0);
		}
	}
	else EndDialog(0);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CHIDClientDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CHIDClientDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CHIDClientDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CHIDClientDlg::OnButtonSend1() 
{
	UpdateData(TRUE);
	m_Socket.Send("set text 0 0 "+m_strLine1.Left(40));
}

void CHIDClientDlg::OnButtonSend2() 
{
	UpdateData(TRUE);
	m_Socket.Send("set text 0 1 "+m_strLine2.Left(40));
}

void CHIDClientDlg::OnButtonClear() 
{
	m_Socket.Send("set clear");
}

void CHIDClientDlg::OnCheckBlight() 
{
	UpdateData(TRUE);
	
	if (m_bBacklight) m_Socket.Send("set blight 1");
	else m_Socket.Send("set blight 0");
}

void CHIDClientDlg::OnReleasedcaptureSliderContrast(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);

	CString msg;msg.Format("set contrast %d",0x40 - m_nSlider);
	m_Socket.Send(msg);
	
	*pResult = 0;
}

void CHIDClientDlg::OnCheckLed1() 
{
	UpdateData(TRUE);

	unsigned char leds = 0;
	if (m_bLed1) leds |= 0x01;
	if (m_bLed2) leds |= 0x02;
	if (m_bLed3) leds |= 0x04;
	if (m_bLed4) leds |= 0x08;
	if (m_bLed5) leds |= 0x10;
	if (m_bLed6) leds |= 0x20;
	if (m_bLed7) leds |= 0x40;
	if (m_bLed8) leds |= 0x80;

	CString msg;msg.Format("set led x%02x",leds);
	m_Socket.Send(msg);
}

void CHIDClientDlg::OnCheckLed2() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnCheckLed3() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnCheckLed4() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnCheckLed5() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnCheckLed6() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnCheckLed7() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnCheckLed8() 
{
	OnCheckLed1();
}

void CHIDClientDlg::OnButtonFont() 
{
	UpdateData(TRUE);
	
	char ch[8];
	packChar(&ch[0], m_Font11.GetCheck()!=0, m_Font21.GetCheck()!=0, m_Font31.GetCheck()!=0, m_Font41.GetCheck()!=0, m_Font51.GetCheck()!=0);
	packChar(&ch[1], m_Font12.GetCheck()!=0, m_Font22.GetCheck()!=0, m_Font32.GetCheck()!=0, m_Font42.GetCheck()!=0, m_Font52.GetCheck()!=0);
	packChar(&ch[2], m_Font13.GetCheck()!=0, m_Font23.GetCheck()!=0, m_Font33.GetCheck()!=0, m_Font43.GetCheck()!=0, m_Font53.GetCheck()!=0);
	packChar(&ch[3], m_Font14.GetCheck()!=0, m_Font24.GetCheck()!=0, m_Font34.GetCheck()!=0, m_Font44.GetCheck()!=0, m_Font54.GetCheck()!=0);
	packChar(&ch[4], m_Font15.GetCheck()!=0, m_Font25.GetCheck()!=0, m_Font35.GetCheck()!=0, m_Font45.GetCheck()!=0, m_Font55.GetCheck()!=0);
	packChar(&ch[5], m_Font16.GetCheck()!=0, m_Font26.GetCheck()!=0, m_Font36.GetCheck()!=0, m_Font46.GetCheck()!=0, m_Font56.GetCheck()!=0);
	packChar(&ch[6], m_Font17.GetCheck()!=0, m_Font27.GetCheck()!=0, m_Font37.GetCheck()!=0, m_Font47.GetCheck()!=0, m_Font57.GetCheck()!=0);
	packChar(&ch[7], m_Font18.GetCheck()!=0, m_Font28.GetCheck()!=0, m_Font38.GetCheck()!=0, m_Font48.GetCheck()!=0, m_Font58.GetCheck()!=0);

	CString msg;
	msg.Format("set font %d x%02x x%02x x%02x x%02x x%02x x%02x x%02x x%02x "
				,m_nFont, ch[0], ch[1], ch[2], ch[3], ch[4], ch[5], ch[6], ch[7]);
	m_Socket.Send(msg);
}

void CHIDClientDlg::packChar(char* ch, bool b1, bool b2, bool b3, bool b4, bool b5)
{
	*ch = 0;

	if (b5) *ch |= 0x01;
	if (b4) *ch |= 0x02;
	if (b3) *ch |= 0x04;
	if (b2) *ch |= 0x08;
	if (b1) *ch |= 0x10;
}

void CHIDClientDlg::OnOK() 
{
//	CDialog::OnOK();
}

void CHIDClientDlg::OnCancel() 
{
	CDialog::OnCancel();
}

void CHIDClientDlg::AddMessage(const char* mesg)
{
	m_lock.lock();
	m_messages.AddTail(CString(mesg));
	m_lock.unlock();
	if (GetSafeHwnd()) PostMessage(WM_USER);
}

long CHIDClientDlg::MyUpdate(WPARAM uID, LPARAM lParam)
{
	m_lock.lock();
	while (!m_messages.IsEmpty())
	{
		parseCmd(m_messages.RemoveHead());
	}
	m_lock.unlock();
	return 0;
}

void CHIDClientDlg::parseCmd(const char* command)
{
	if (!command) return;
	int len = strlen(command);
	if (!len) return;

	char* tcmd = new char[len+1];
	strcpy(tcmd, command);
	char* cmd = strtok(tcmd, " \r\n");
	char* sub = strtok(NULL, " \r\n");
	
	bool ok = false;
	
	if (strcmp(cmd, "disconnected") == 0)
	{
		AfxMessageBox("Connection dropped by server\n");
		if (m_dlgEpromInt) m_dlgEpromInt->EndDialog(0);
		if (m_dlgEpromExt) m_dlgEpromExt->EndDialog(0);
		OnCancel();
	}
	else if (strcmp(cmd, "err") == 0)
	{
		if (strcmp(sub, "flasher") == 0)
		{
			AfxMessageBox("Device in flashing mode - normal actions not permitted\n");
			OnCancel();
		}
	}
	else if (strcmp(cmd, "set") == 0)
	{
		if (strcmp(sub, "led") == 0)
		{
			char* status = strtok(NULL, " \r\n");
			if (status)
			{
				unsigned char nstat = (unsigned char)getno(status);

				m_bLed1 = (nstat & 0x01) != 0;
				m_bLed2 = (nstat & 0x02) != 0;
				m_bLed3 = (nstat & 0x04) != 0;
				m_bLed4 = (nstat & 0x08) != 0;
				m_bLed5 = (nstat & 0x10) != 0;
				m_bLed6 = (nstat & 0x20) != 0;
				m_bLed7 = (nstat & 0x40) != 0;
				m_bLed8 = (nstat & 0x80) != 0;

				UpdateData(FALSE);
			}
		}
		if (strcmp(sub, "lcd") == 0)
		{
			char* status = strtok(NULL, " \r\n");
			if (status)
			{
				unsigned char nstat = (unsigned char)getno(status);

				m_bCursorBlink	= (nstat & 0x01) != 0;
				m_bCursorOn		= (nstat & 0x02) != 0;
				m_bLCDOn		= (nstat & 0x04) != 0;

				UpdateData(FALSE);
			}
		}
		else if (strcmp(sub, "blight") == 0)
		{
			char* status = strtok(NULL, " \r\n");
			if (status)
			{
				unsigned char nstat = (unsigned char)getno(status);
				m_bBacklight = nstat != 0;

				UpdateData(FALSE);
			}
		}
		else if (strcmp(sub, "contrast") == 0)
		{
			char* status = strtok(NULL, " \r\n");
			if (status)
			{
				unsigned char nstat = (unsigned char)getno(status);
				m_nSlider = 0x40 - nstat;

				UpdateData(FALSE);
			}
		}
		else if (strcmp(sub, "clear") == 0)
		{
			m_strLine1 = "";
			m_strLine2 = "";

			UpdateData(FALSE);
		}
		else if (strcmp(sub, "text") == 0)
		{
			char* x = strtok(NULL, " \r\n");
			char* y = strtok(NULL, " \r\n");
			char* text = strtok(NULL, "");

			if (x && y && text)
			{
				char nx = (char)getno(x);
				if (nx < 0) nx = 0;
				if (nx > 9) nx = 9;

				char ny = (char)getno(y);
				if (ny < 0) ny = 0;
				if (ny > 1) ny = 1;

				if (ny == 0) m_strLine1 = text;
				else m_strLine2 = text;

				UpdateData(FALSE);
			}
		}
		else if (strcmp(sub, "splash") == 0)
		{
			m_strLine1 = "--- splash test --- ";
			m_strLine2 = "--- splash test --- ";

			UpdateData(FALSE);
		}
	}//set
	else if (strcmp(cmd, "notify") == 0)
	{
		if (strcmp(sub, "key") == 0)
		{
			char* k1 = strtok(NULL, " \r\n");
			char* k2 = strtok(NULL, " \r\n");
			
			CString keys;
			keys.Format("%02X %02X", getno(k1), getno(k2));

			while (m_listKey.GetCount() > 6) m_listKey.DeleteString(0);
			m_listKey.AddString(keys);
		}
		else if (strcmp(sub, "ir") == 0)
		{
			TRACE("IR\n");
			char* slen = strtok(NULL, " \r\n");
			int len = getno(slen);

			CString ir,t;
			ir.Format("[%02d]", len);

			for (int i=0;i<len;i++)
			{
				t.Format(" %02X", getno(strtok(NULL, " \r\n")));
				ir += t;
			}

			while (m_listIR.GetCount() > 6) m_listIR.DeleteString(0);
			m_listIR.AddString(ir);
		}
		else if (strcmp(sub, "ir_rc5") == 0)
		{
			TRACE("IR_RC5\n");
			char* sval = strtok(NULL, " \r\n");
			int val = getno(sval);

			CString ir;
			ir.Format("rc5 code=%04x", val);

			while (m_listIR.GetCount() > 6) m_listIR.DeleteString(0);
			m_listIR.AddString(ir);
		}
	}//notify
	else if (strcmp(cmd, "get") == 0)
	{
		if (strcmp(sub, "inte") == 0)
		{//internal eprom
			const char* tstr = command + 9;

			char no[3];no[2] = 0;
			char line[21];line[20]=0;
			unsigned long min, sec, led, nextslot, repetition;

			for (int i=0;i<5;i++)
			{
				no[0] = tstr[i*STR_LINE_LEN];no[1] = tstr[i*STR_LINE_LEN+1];
				min = atol(no);
				if (m_dlgEpromInt) m_dlgEpromInt->SetMin(i, no);

				no[0] = tstr[i*STR_LINE_LEN+3];no[1] = tstr[i*STR_LINE_LEN+4];
				sec = atol(no);
				if (m_dlgEpromInt) m_dlgEpromInt->SetSec(i, no);

				no[0] = tstr[i*STR_LINE_LEN+6];no[1] = tstr[i*STR_LINE_LEN+7];
				nextslot = strtol(no, NULL, 16);
				no[0] = tstr[i*STR_LINE_LEN+9];no[1] = tstr[i*STR_LINE_LEN+10];
				repetition = strtol(no, NULL, 16);
				no[0] = tstr[i*STR_LINE_LEN+12];no[1] = tstr[i*STR_LINE_LEN+13];
				led = strtol(no, NULL, 16);

				if (m_dlgEpromInt) m_dlgEpromInt->SetAdditionalInfo(i, led, nextslot, repetition);

				int j = 0;

				for (j=0;j<20;j++)
					line[j] = tstr[i*STR_LINE_LEN+15+j];

				if (m_dlgEpromInt) m_dlgEpromInt->SetLine1(i, line);

				for (j=0;j<20;j++)
					line[j] = tstr[i*STR_LINE_LEN+36+j];

				if (m_dlgEpromInt) m_dlgEpromInt->SetLine2(i, line);

				if (m_dlgEpromInt) m_dlgEpromInt->CheckTime(i);
			}
		}
		else if (strcmp(sub, "exte") == 0)
		{//internal eprom
			const char* tstr = command + 9;

			char no[3];no[2] = 0;
			char line[21];line[20]=0;
			unsigned long min, sec, led, nextslot, repetition;

			for (int i=0;i<5;i++)
			{
				no[0] = tstr[i*STR_LINE_LEN];no[1] = tstr[i*STR_LINE_LEN+1];
				min = atol(no);
				if (m_dlgEpromExt) m_dlgEpromExt->SetMin(i, no);

				no[0] = tstr[i*STR_LINE_LEN+3];no[1] = tstr[i*STR_LINE_LEN+4];
				sec = atol(no);
				if (m_dlgEpromExt) m_dlgEpromExt->SetSec(i, no);

				no[0] = tstr[i*STR_LINE_LEN+6];no[1] = tstr[i*STR_LINE_LEN+7];
				nextslot = strtol(no, NULL, 16);
				no[0] = tstr[i*STR_LINE_LEN+9];no[1] = tstr[i*STR_LINE_LEN+10];
				repetition = strtol(no, NULL, 16);
				no[0] = tstr[i*STR_LINE_LEN+12];no[1] = tstr[i*STR_LINE_LEN+13];
				led = strtol(no, NULL, 16);

				if (m_dlgEpromExt) m_dlgEpromExt->SetAdditionalInfo(i, led, nextslot, repetition);

				int j = 0;

				for (j=0;j<20;j++)
					line[j] = tstr[i*STR_LINE_LEN+15+j];

				if (m_dlgEpromExt) m_dlgEpromExt->SetLine1(i, line);

				for (j=0;j<20;j++)
					line[j] = tstr[i*STR_LINE_LEN+36+j];

				if (m_dlgEpromExt) m_dlgEpromExt->SetLine2(i, line);

				if (m_dlgEpromExt) m_dlgEpromExt->CheckTime(i);
			}
		}
	}

	delete tcmd;
}

CString CHIDClientDlg::fillString(CString str, int len)
{
	if (str.GetLength() < len)
	{
		while (str.GetLength()<len) str += " ";
		return str;
	}
	else return str.Left(len);
}

CString CHIDClientDlg::getInt(int n)
{
	CString ret;
	ret.Format("%02x", n & 0xFF);

	return ret;	
}

CString CHIDClientDlg::getNo(CString str)
{
	int no = atoi(str);
	if (no>59) no = 59;

	CString ret;
	ret.Format("%02d", no);

	return ret;
}

void CHIDClientDlg::sendToSocket(const char* mesg)
{
	m_Socket.Send(mesg);
}


void CHIDClientDlg::OnCheckCursorBlink() 
{
	UpdateData(TRUE);

	unsigned char lcd = 0;
	if (m_bCursorBlink) lcd |= 0x01;
	if (m_bCursorOn)    lcd |= 0x02;
	if (m_bLCDOn)		lcd |= 0x04;
	
	CString msg;msg.Format("set lcd x%02x",lcd);
	m_Socket.Send(msg);
}

void CHIDClientDlg::OnCheckCursorOnoff() 
{
	OnCheckCursorBlink();
}

void CHIDClientDlg::OnCheckLcdOnoff() 
{
	OnCheckCursorBlink();
}

void CHIDClientDlg::OnButtonRelay() 
{
	CRelayDlg dlg(this);
	dlg.DoModal();
}

void CHIDClientDlg::OnButtonEprom() 
{
	CEpromDlg dlg(true, this);
	m_dlgEpromInt = &dlg;
	dlg.DoModal();
	m_dlgEpromInt = NULL;
}

void CHIDClientDlg::OnButtonEprom2() 
{
	CEpromDlg dlg(false, this);
	m_dlgEpromExt = &dlg;
	dlg.DoModal();
	m_dlgEpromExt = NULL;
}
