// HIDClientDlg.h : header file
//

#if !defined(AFX_HIDCLIENTDLG_H__3AC4A474_9544_41A3_9D50_6893D194FF91__INCLUDED_)
#define AFX_HIDCLIENTDLG_H__3AC4A474_9544_41A3_9D50_6893D194FF91__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "HIDClientSocket.h"
#include "utils/HLock.h"
/////////////////////////////////////////////////////////////////////////////
// CHIDClientDlg dialog
class CEpromDlg;

class CHIDClientDlg : public CDialog
{
// Construction
public:
	CHIDClientDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CHIDClientDlg)
	enum { IDD = IDD_HIDCLIENT_DIALOG };
	CSliderCtrl	m_Slider;
	CListBox	m_listKey;
	CListBox	m_listIR;
	BOOL	m_bBacklight;
	BOOL	m_bLed1;
	BOOL	m_bLed2;
	BOOL	m_bLed3;
	BOOL	m_bLed4;
	BOOL	m_bLed5;
	BOOL	m_bLed6;
	BOOL	m_bLed7;
	BOOL	m_bLed8;
	int		m_nFont;
	CString	m_strLine1;
	CString	m_strLine2;
	int		m_nSlider;
	CButton	m_Font11;
	CButton m_Font12;
	CButton m_Font13;
	CButton m_Font14;
	CButton m_Font15;
	CButton m_Font16;
	CButton m_Font17;
	CButton m_Font18;
	CButton m_Font21;
	CButton m_Font22;
	CButton m_Font23;
	CButton m_Font24;
	CButton m_Font25;
	CButton m_Font26;
	CButton m_Font27;
	CButton m_Font28;
	CButton m_Font31;
	CButton m_Font32;
	CButton m_Font33;
	CButton m_Font34;
	CButton m_Font35;
	CButton m_Font36;
	CButton m_Font37;
	CButton m_Font38;
	CButton m_Font41;
	CButton m_Font42;
	CButton m_Font43;
	CButton m_Font44;
	CButton m_Font45;
	CButton m_Font46;
	CButton m_Font47;
	CButton m_Font48;
	CButton m_Font51;
	CButton m_Font52;
	CButton m_Font53;
	CButton m_Font54;
	CButton m_Font55;
	CButton m_Font56;
	CButton m_Font57;
	CButton m_Font58;
	BOOL	m_bCursorBlink;
	BOOL	m_bCursorOn;
	BOOL	m_bLCDOn;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHIDClientDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	void AddMessage(const char* mesg);
	void parseCmd(const char* command);
	CString fillString(CString str, int len);
	CString getNo(CString str);
	CString getInt(int n);

	void sendToSocket(const char* mesg);
protected:
	CList<CString, CString&> m_messages;
	HLock m_lock;

	HICON m_hIcon;
	HIDClientSocket m_Socket;
	
	CEpromDlg* m_dlgEpromInt;
	CEpromDlg* m_dlgEpromExt;

	void packChar(char* ch, bool b1, bool b2, bool b3, bool b4, bool b5); 

	// Generated message map functions
	//{{AFX_MSG(CHIDClientDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnButtonSend1();
	afx_msg void OnButtonSend2();
	afx_msg void OnButtonClear();
	afx_msg void OnCheckBlight();
	afx_msg void OnReleasedcaptureSliderContrast(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCheckLed1();
	afx_msg void OnCheckLed2();
	afx_msg void OnCheckLed3();
	afx_msg void OnCheckLed4();
	afx_msg void OnCheckLed5();
	afx_msg void OnCheckLed6();
	afx_msg void OnCheckLed7();
	afx_msg void OnCheckLed8();
	afx_msg void OnButtonFont();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnCheckFont1();
	afx_msg void OnButtonEprom();
	afx_msg void OnCheckCursorBlink();
	afx_msg void OnCheckCursorOnoff();
	afx_msg void OnCheckLcdOnoff();
	afx_msg void OnButtonRelay();
	afx_msg void OnButtonEprom2();
	//}}AFX_MSG
	afx_msg long MyUpdate(WPARAM uID, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_HIDCLIENTDLG_H__3AC4A474_9544_41A3_9D50_6893D194FF91__INCLUDED_)
