// HIDClientSocket.cpp: implementation of the HIDClientSocket class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HIDClient.h"
#include "HIDClientSocket.h"
#include "HIDClientDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HIDClientSocket::HIDClientSocket(CHIDClientDlg* pDlg)
{
	m_pSocket = NULL;
	m_pDlg = pDlg;
}

HIDClientSocket::~HIDClientSocket()
{
	if (m_pSocket) m_pSocket->setStatus(-1);

	stop();

	if (m_pSocket) delete m_pSocket;
	m_pSocket = NULL;
}

void HIDClientSocket::Connect(const char* host, int port)
{
	if (m_pSocket) delete m_pSocket;

	m_pSocket = new HClientSock(host, port);
}

bool HIDClientSocket::isConnected()
{
	if (!m_pSocket) return false;

	return (m_pSocket->getStatus() != -1);
}

void HIDClientSocket::Send(const char* mesg)
{
	if (m_pSocket)
	{
		m_pSocket->sendData(mesg, strlen(mesg));
		m_pSocket->sendData("\r\n", 2);
	}
}

void HIDClientSocket::run()
{
	const int intSize = 10000;
	char a[intSize];
	while (isRunning())
	{
		if (m_pSocket && (m_pSocket->getStatus() == 0))
		{
			int size=m_pSocket->getLine( a,intSize );
			if( size < 0 )
			{
				TRACE("Disconnected \n");
				if (m_pSocket) m_pSocket->setStatus(-1);
				m_pDlg->AddMessage("disconnected");
			}
			else if (size != 0)
			{
				a[size] = 0;
				TRACE( "RX:%s\n" , a);
				m_pDlg->AddMessage(a);
			}
		}
		Sleep(10);
	}
}

