// RelayDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HIDClient.h"
#include "HIDClientDlg.h"
#include "RelayDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRelayDlg dialog


CRelayDlg::CRelayDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRelayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRelayDlg)
	m_lMsec = 0;
	//}}AFX_DATA_INIT

	m_pHIDDlg = (CHIDClientDlg*) pParent;
}


void CRelayDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRelayDlg)
	DDX_Text(pDX, IDC_EDIT_MSEC, m_lMsec);
	DDV_MinMaxLong(pDX, m_lMsec, 1, 65535);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRelayDlg, CDialog)
	//{{AFX_MSG_MAP(CRelayDlg)
	ON_BN_CLICKED(IDC_BUTTON_ON, OnButtonOn)
	ON_BN_CLICKED(IDC_BUTTON_OFF, OnButtonOff)
	ON_BN_CLICKED(IDC_BUTTON_ON_MSEC, OnButtonOnMsec)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRelayDlg message handlers

void CRelayDlg::OnOK() 
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CRelayDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CRelayDlg::OnButtonOn() 
{
	m_pHIDDlg->sendToSocket("set relay -1");
}

void CRelayDlg::OnButtonOff() 
{
	m_pHIDDlg->sendToSocket("set relay 0");
}

void CRelayDlg::OnButtonOnMsec() 
{
	UpdateData(TRUE);
	CString str; str.Format("%d", m_lMsec);
	
	m_pHIDDlg->sendToSocket("set relay "+str);
}
