// HArray.cpp: implementation of the HArray class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HArray.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HArray::HArray()
{
	m_pArray = NULL;m_nLen = 0;
}

HArray::HArray(char* array)
{
	m_pArray = NULL;m_nLen = 0;
	setValue(array);
}

HArray::HArray(unsigned char* array, int len)
{
	m_pArray = NULL;m_nLen = 0;
	setValue(array, len);
}

HArray::HArray(unsigned short* array)
{
	m_pArray = NULL;m_nLen = 0;
	setValue(array);
}

HArray::HArray(int len)
{
	m_nLen = len;
	m_pArray = new unsigned char[len];
	memset(m_pArray, 0, len);
}

HArray::~HArray()
{
	if (m_pArray) delete m_pArray;
}

bool HArray::equals(HArray* array)
{
	if (this->m_nLen != array->length()) return false;

	for (unsigned int i = 0;i<this->m_nLen;i++)
		if (this->m_pArray[i] != array->getBuf()[i]) return false;

	return true;
}

void HArray::setValue(char* array)
{
	if (m_pArray) delete m_pArray;

	m_nLen = strlen(array)+1;
	m_pArray = new unsigned char[m_nLen];
	strcpy((char*)m_pArray, array);
}

void HArray::setValue(unsigned short* array)
{
	if (m_pArray) delete m_pArray;

	m_nLen = 2*wcslen((wchar_t*)array)+2;
	m_pArray = new unsigned char[m_nLen];
	wcscpy((wchar_t*)m_pArray, (wchar_t*)array);
}

void HArray::setValue(unsigned char* array, int len)
{
	if (m_pArray) delete m_pArray;

	m_nLen = len;
	m_pArray = new unsigned char[len];
	memcpy(m_pArray, array, len);
}

void HArray::setHIDPkt(unsigned char rid, unsigned int rlen, unsigned int len, ...)
{
	if (m_pArray) delete m_pArray;

	m_nLen = rlen + 1;
	m_pArray = new unsigned char[rlen+1];
	m_pArray[0] = rid;

	va_list args;
	va_start(args, len);
	
	unsigned int cnt = 0;
	unsigned char i = va_arg(args, unsigned char);
	while (cnt<len)
	{
		m_pArray[1+cnt] = i;
		cnt++;
		if (cnt < len) i = va_arg(args, unsigned char);
	}
	
	va_end(args);
}