#include "stdafx.h"
#include "HClientSock.h"

HClientSock::HClientSock( const char* host, int port )
:HSocket(host, port)
{
	m_port = port;
	m_hostName = NULL;
	if( host != NULL )
	{
		int len = strlen( host );
		m_hostName = new char[len + 1];
		strcpy( m_hostName, host );
	}
	makeSocket();
}

HClientSock::~HClientSock()
{
	if( m_hostName != NULL )
	{
		delete[] m_hostName;
		m_hostName = NULL;
	}
}

bool HClientSock::makeSocket( void )
{	
	struct sockaddr_in socketInfo;
	struct hostent *hostinfo;
	
	SOCKET sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock == INVALID_SOCKET )
	{
		return false;
	}
#ifdef _WIN32
	const char noDelay = 1;
	if( setsockopt( sock, IPPROTO_TCP, TCP_NODELAY, &noDelay, sizeof( int ) ) != 0 )
	{
		HSocket sk( sock , m_hostName, m_port);
		sk.setStatus( -1 );
		return false;
	}
#endif
	socketInfo.sin_family = AF_INET;
	socketInfo.sin_port = htons( m_port );

	hostinfo = gethostbyname( m_hostName );
	if( hostinfo == NULL )
	{
		socketInfo.sin_addr.s_addr = inet_addr( m_hostName );
	}
	else
	{
		socketInfo.sin_addr = *(struct in_addr*)hostinfo->h_addr;
	}

	int status = connect( sock, (struct sockaddr*)&socketInfo, sizeof( struct sockaddr_in ) );
	if( status == SOCKET_ERROR )
	{
		HSocket sk( sock , m_hostName, m_port);
		sk.setStatus( -1 );
		return false;
 	}
	
	setSocket( sock );

	setMode( );

	return true;
}
