#include "stdafx.h"
#include "HServerSock.h"

HServerSock::HServerSock( int port )
:HSocket("SERVER2", port)
{
	m_port = port;
	m_brun = makeSocket();

	if (m_brun)
		 TRACE ("Server socket started: %d\n", port);
	else TRACE ("Server socket NOT started: %d (port already used)\n", port);
}

HServerSock::~HServerSock()
{
}

bool HServerSock::makeSocket( void )
{	
	struct sockaddr_in socketInfo;
	SOCKET sock = socket( AF_INET, SOCK_STREAM, 0 );
	if( sock == INVALID_SOCKET )
	{
		return false;
	}

#ifdef _WIN32
	const char noDelay = 1;
	if( setsockopt( sock, IPPROTO_TCP, TCP_NODELAY, &noDelay, sizeof( int ) ) != 0 )
	{
		HSocket sk( sock ,"SERVER3", m_port);
		sk.setStatus( -1 );
		return false;
	}
#endif

	socketInfo.sin_family = AF_INET;
	socketInfo.sin_port = htons (m_port);
	socketInfo.sin_addr.s_addr = htonl (INADDR_ANY);

#ifndef _WIN32
	int tmp=1;
	setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &tmp,sizeof(int));//fac ca socketul sa poata fi listener la port, chiar daca a fost inchis portul de curand
#endif

	int status = bind( sock, (struct sockaddr*)&socketInfo, sizeof( struct sockaddr_in ) );
	if (status == SOCKET_ERROR)
	{
#ifdef _WIN32
		TRACE("Error %d\n",WSAGetLastError());
#else
#endif
		HSocket sk( sock , "SERVER3", m_port);
		sk.setStatus( -1 );
		return false;
	}
	setSocket( sock );
	listen (getSocket(), 10);
	return true;
}


SOCKET HServerSock::acceptSocket( struct sockaddr *sad )
{
	struct sockaddr socketAddress;
	socklen_t size = sizeof (struct sockaddr);
	SOCKET sock = accept (m_socket, &socketAddress,&size );
	if( sad!= NULL )
	{
		memcpy( sad, &socketAddress, sizeof( struct sockaddr ) );
	}

	return sock;
}
