
#ifndef __SOCKET_H__
#define __SOCKET_H__

#ifdef _WIN32
//#include "winsock2.h"
typedef int socklen_t;
#define MSG_NOSIGNAL	0
#define	MSG_WAITALL		0
#else
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <stropts.h>
typedef int SOCKET;
#define INVALID_SOCKET	-1
#define SOCKET_ERROR	-1
#endif	

//#define BLOCKING

class HSocket
{
public:
	HSocket(const char* strIP,unsigned int port);
	HSocket( SOCKET socket, const char* strIP,unsigned int port);
	virtual ~HSocket();

	int getStatus( void );
	void setStatus( int status );
	int getData( char* buffer , int buffSize );
	int sendData( const char* buffer , int buffSize );
	int getLine( char* buffer ,int buffSize);
	inline SOCKET& getSocket()
	{
		return m_socket;
	}
	void setSocket( SOCKET sock );
	void setMode( );
	void flush( void );

	bool SetInBufLen(int nLen);
	bool SetOutBufLen(int nLen);

	static bool initSocketLibrary( unsigned int VerMajor,unsigned int VerMinor);
	static void closeSocketLibrary( void );

protected:
	SOCKET m_socket;
	int m_status;	
	static bool m_initialized;//TRUE if socket library initialized

#ifdef _WIN32	
	SOCKADDR_IN 
#else 
	sockaddr_in
#endif
	local_sin,              //	Local socket's address
	destrecv_sin;           //	Holds the source address upon recvfrom function returns if MC_CLIENT_RECEIVER or
							//	Holds the destination socket's address information

	char* m_myIP;
	unsigned int m_myPort;
};

#endif //__SOCKET_H__
