// HEXFile.cpp: implementation of the HEXFile class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HEXFile.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HEXFile::HEXFile(const char* file)
{
	m_File = NULL;
	m_strFile = new char[strlen(file)+1];
	strcpy(m_strFile, file);

	m_nMaxLines = 0;
	m_nCurLength = 0;
	
	m_nExtendedLinearAddr = 0;
	m_nExtendedSegmentAddr = 0;
	m_nCurAddr = 0;
}

HEXFile::~HEXFile()
{
	delete m_strFile;
	Close();
}

int HEXFile::Open()
{
	if (m_File)
	{
		fclose(m_File);
		m_File = NULL;
	}

	m_File = fopen(m_strFile, "rt");
	m_nMaxLines = 0;
	m_nCurLine = 0;
	m_nExtendedLinearAddr = 0;
	m_nExtendedSegmentAddr = 0;
	m_nCurAddr = 0;
	if (m_File)
	{
		char* res = fgets(m_fileBuff, MAX_LINE_LEN - 1, m_File);
		while (res)
		{
			m_nMaxLines ++;
			
			int len = strlen(m_fileBuff); 
			if ((len < 9)||(m_fileBuff[0] != ':'))
			{
				printf("Invalid hexfile\r\n");
				fclose(m_File);
				m_File = NULL;
				return 2;
			}

			res = fgets(m_fileBuff, MAX_LINE_LEN - 1, m_File);
		}

		rewind(m_File);

		printf("File %s opened: %d lines\r\n",m_strFile,m_nMaxLines);
		return 0;
	}
	else
	{
		printf("File %s could not be opened\r\n",m_strFile);
		return 1;
	}
}

void HEXFile::Close()
{
	if (m_File)
	{
		fclose(m_File);
		m_File = NULL;
	}
}

void HEXFile::Reset()
{
	m_nCurLine = 0;
	m_nExtendedLinearAddr = 0;
	m_nExtendedSegmentAddr = 0;
	m_nCurAddr = 0;

	if (m_File) 
		rewind(m_File);
}

unsigned long HEXFile::GetGlobalAddress()
{
	return m_nExtendedSegmentAddr + m_nExtendedLinearAddr + m_nCurAddr;
}

int HEXFile::NextLine()
{
	if (!m_File) return 1;

	//:llaaaatt[dd...]cc
	char* res = fgets(m_fileBuff, MAX_LINE_LEN - 1, m_File);
	m_fileBuff[MAX_LINE_LEN-1] = 0;

	if (res == NULL) return 1;//eof

	int len = strlen(m_fileBuff); 
	if (m_fileBuff[len - 1] == 10) m_fileBuff[len - 1] = 0;
	len = strlen(m_fileBuff);

	if ((len < 9)||(m_fileBuff[0] != ':'))
	{
		printf("Invalid hexfile\n");
		return 2;
	}

	m_nCurLine ++;

	unsigned char dlen = getmchar(1);
	m_nCurAddr		   = getmint(3);
	unsigned char type = getmchar(7);

	unsigned char calc_chksum = dlen + (unsigned char)(m_nCurAddr & 0xff) + (unsigned char)((m_nCurAddr >> 8) & 0xff) + type;
	unsigned char chksum = calc_chksum;
	m_nCurLength = 0;
	if (dlen > 0)
	{
		int pos = 0;
		
		while (pos < dlen)
		{
			m_byteBuff[pos] = getmchar(pos*2 + 9);
			calc_chksum += m_byteBuff[pos];
			pos ++;
		}

		m_nCurLength = pos;

		if (m_nCurLength != dlen)
		{
			printf("Invalid length at line %d: %d!=%d\n",m_nCurLine,m_nCurLength,dlen);
			printf("   >>%s\n",m_fileBuff);
			return 3;
		}

		calc_chksum = 0x01 + (~calc_chksum);
		chksum = getmchar(pos*2 + 9);
	}

	if (calc_chksum != chksum)
	{
		printf("Invalid checksum at line %d: %x!=%x\n",m_nCurLine,calc_chksum,chksum);
		printf("   >>%s\n",m_fileBuff);
		return 4;
	}

	switch (type)
	{
	case 0x00:// - data record
		{
			//printf("Data: %d\n",m_nCurLength);
			return 0;
		}break;
	case 0x01:// - end-of-file record
		{
			printf ("End of hexfile\n");
			return 1;
		}break;
	case 0x02:// - extended segment address record
		{
			m_nExtendedSegmentAddr = getmint(9) << 4;
			printf ("Extended segment address record %08x\n", m_nExtendedSegmentAddr);
			printf("   >%d>%s\n",m_nCurLine,m_fileBuff);

			return NextLine();
		}break;
	case 0x04:// - extended linear address record 
		{
			m_nExtendedLinearAddr = getmint(9) << 16;
			printf ("Extended linear address record %08x\n", m_nExtendedLinearAddr);
			printf("   >%d>%s\n",m_nCurLine,m_fileBuff);

			return NextLine();
		}break;
	default:
		{
			printf("Error - unknown type: %x\n",type);
			return 5;
		}
	}
}

unsigned char HEXFile::getmchar(int pos)
{
	char str[3];
	strncpy(str, m_fileBuff+pos, 2);
	str[2] = 0;

	return (char)strtoul(str, NULL, 16);
}

unsigned int  HEXFile::getmint(int pos)
{
	char str[5];
	strncpy(str, m_fileBuff+pos, 4);
	str[4] = 0;

	return strtoul(str, NULL, 16);
}
