// HEXFile.h: interface for the HEXFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HEXFILE_H__0AEEDF89_091F_4193_B748_F3C637AA4CE0__INCLUDED_)
#define AFX_HEXFILE_H__0AEEDF89_091F_4193_B748_F3C637AA4CE0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_LINE_LEN 256*2+256

#ifdef HIDAPI_EXPORTS
class HIDAPI_API HEXFile  
#else
class HEXFile
#endif
{
public:
	/** Creates a hex file with the name file*/
	HEXFile(const char* file);
	virtual ~HEXFile();

	/** Open the file (if already opened the old one is closed and repoened again)*/
	int Open();
	/** Close the file */
	void Close();
	/** Jumping to the start of the file*/
	void Reset();

	/** Get one more line from the file
	 * return: 0 = ok, 1 = eof, 2,3,4... - invalid hex file
	 */
	int NextLine();

	unsigned long GetGlobalAddress();
	int GetLength(){return m_nCurLength;};
	const unsigned char* GetData(){return m_byteBuff;};
	
	int GetCurLine(){return m_nCurLine;};
	int GetMaxLines(){return m_nMaxLines;};
	
private:
	unsigned char getmchar(int pos);
	unsigned int  getmint(int pos);

	unsigned long m_nExtendedSegmentAddr;
	unsigned long m_nExtendedLinearAddr;
	unsigned long m_nCurAddr;
	int	m_nCurLength;
	int m_nCurLine;
	int m_nMaxLines;

	char* m_strFile;
	FILE* m_File;

	unsigned char m_byteBuff[256];
	char m_fileBuff[MAX_LINE_LEN];
};

#endif // !defined(AFX_HEXFILE_H__0AEEDF89_091F_4193_B748_F3C637AA4CE0__INCLUDED_)
