// HIDAcme.h: interface for the HIDAcme class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HIDACME_H__297E4426_06E1_4E28_B062_EECB4C88DF5C__INCLUDED_)
#define AFX_HIDACME_H__297E4426_06E1_4E28_B062_EECB4C88DF5C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "HIDInterface.h"
#include "utils/HLock.h"
#include "IRDecoder.h"

#define MANUFACTURER "ITUNER INC"
#define PROD_LCD	 "USB-LCD-20x2"
#define PROD_FLASH	 "USB-LCD-20x2 Flasher"

#define LINE_LENGTH		20
#define MAX_BUF			500

class HIDSocket;
class HIDGraphics;

#define STATUS_OK				0x00
#define STATUS_ERASE			0x01
#define STATUS_WRITE			0x02
#define STATUS_READ				0x03
#define STATUS_ERROR			0xff

//Keyboard mode
#define IN_REPORT_POWER_STATE		0x01
#define IN_REPORT_KEY_STATE			0x11
#define IN_REPORT_IR_DATA			0x21
#define OUT_REPORT_LED_STATE		0x81
#define OUT_REPORT_LCD_BACKLIGHT	0x91
#define OUT_REPORT_LCD_CONTRAST		0x92
#define OUT_REPORT_LCD_CONTROL		0x93
#define OUT_REPORT_LCD_CLEAR		0x94
#define OUT_REPORT_LCD_TEXT			0x98
#define OUT_REPORT_LCD_FONT			0x9C
//flasher mode
#define RESULT_OK					0x00
#define RESULT_PARAMETER_MISSING	0x01            	// Request does not contain all necessary parameters (request is too short, no length or no address either).
#define RESULT_DATA_MISSING			0x02				// Request attempts to write more data than was actually sent.
#define RESULT_BLOCK_READ_ONLY		0x03				// Request attempts to erase or write a block within the flasher code section.
#define RESULT_BLOCK_NOT_ERASABLE	0x04            	// Request attempts to erase a block outside of "erasable" memory space.
#define RESULT_BLOCK_TOO_BIG 		0x05          		// Request attempts to access more data at once than the HID buffer can handle.
#define RESULT_SECTION_OVERFLOW		0x06				// Request (address & length) attempts to cross over a section boundary (section boundaries are set at 1Mbyte boundaries -> 0x100000, 0x200000... etc.).
#define HID_REPORT_GET_VERSION		0xF1				// No parameters
#define HID_REPORT_ERASE_MEMORY		0xF2				// AddressLo : AddressHi : AddressUp (anywhere inside the 64 byte-block to be erased)
#define HID_REPORT_READ_MEMORY		0xF3				// AddressLo : AddressHi : AddressUp : Data Length (1...32)
#define HID_REPORT_WRITE_MEMORY		0xF4				// AddressLo : AddressHi : AddressUp : Data Length (1...32) : Data....
#define HID_REPORT_EXIT_FLASHER		0xFF				// No parameters
#define HID_REPORT_EXIT_KEYBOARD	0xEF				// No parameters
#define HID_SET_SNOOZE_TIME			0xF8				// 0-65535 (1234h > 34 12);

#define OUT_REPORT_RELAY_ONOFF		0xB1				// 0-65535 (1234h > 34 12); - internal relay on/off
#define OUT_REPORT_TESTSPLASH		0xC1				// test splash screen

#define IN_REPORT_EXT_EE_DATA		0x31
#define OUT_REPORT_EXT_EE_READ		0xA1
#define OUT_REPORT_EXT_EE_WRITE		0xA2

#define IN_REPORT_INT_EE_DATA		0x32
#define OUT_REPORT_INT_EE_READ		0xA3
#define OUT_REPORT_INT_EE_WRITE		0xA4

#define TYPE_CODE_MEMORY			0x00
#define TYPE_EPROM_EXTERNAL			0x01
#define TYPE_EPROM_INTERNAL			0x02

#ifdef HIDAPI_EXPORTS
class HIDAPI_API HIDAcme : public HIDInterface
#else
class HIDAcme : public HIDInterface
#endif
{
public:
	HIDAcme(HIDDevice* hdev, int timeout, int ir_decoder);
	virtual ~HIDAcme();

	void SetSocket(HIDSocket* sock);

	void getinitmesgs(char* buf);//return's all init messages

	void setLedStatus(unsigned char status);
	void setLCDControl(unsigned char status);
	void setBacklight(unsigned char status);
	void setContrast(unsigned char status);
	void setText(const char x, const char y, const char* text, unsigned int len = 0);
	void setFont(const char n, const char map[8]);
	void setRelay(unsigned long msec);
	void testSplash();
	void clearLCD();

	void sendCmd(const char* command, bool from_socket);
	void connectGraph(HIDGraphics* hg);

	void getVer();

	/** Commands */
	bool writeFile(bool fromsocket, int type, const char* file, const unsigned long end);
	void eraseFlash(bool fromsocket, const unsigned long start, const unsigned long end);
	bool readFile(bool fromsocket, int type, const char* file,const unsigned long start, const unsigned long end);
	
	void switchMode();
	bool loadFile2Array(unsigned char* data, const unsigned long len, const char* file);

	/** Write file from a string*/
	bool writeFile4String(const char* file, const char* str);
	/** Write file from array*/
	bool writeFile4Array(const char* file, const unsigned char* buffer, const unsigned long length);

	bool isFlasher();

	bool isWOK(){return m_bWriteOK;};

	virtual void Received(HArray* array);
private:
	void Send2Socket(const char* mesg, ...);
	void GetLine(char* buf, int ln);
	
	int _eraseFlash(bool fromsocket, const unsigned long start, const unsigned long end);
	int _writeFile(bool fromsocket, int type, const char* file, const unsigned long end);
	int _readFile(bool fromsocket, int type, const char* file,const unsigned long start, const unsigned long end);

	bool _isEnabled(int type);
	int _getWriteMsg(int type);
	int _getReadMsg(int type);

	unsigned char m_cLedStatus;
	unsigned char m_cLCDStatus;
	unsigned char m_cBacklight;
	unsigned char m_cContrast;
	char m_cLine1[LINE_LENGTH];
	char m_cLine2[LINE_LENGTH];

	unsigned char m_cBuff[MAX_BUF];

	int m_nTimeout;

	CIRDecoder m_irDecoder;

	int  m_nError;
	bool m_bWriteOK;
	HArray m_aReceived;

	HLock m_lockSock;
	HLock m_lockCommand;
	
	HIDSocket* m_socket;
	HIDGraphics* m_pGraphics;
};

#endif // !defined(AFX_HIDACME_H__297E4426_06E1_4E28_B062_EECB4C88DF5C__INCLUDED_)
