// HIDDaemon.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "HIDDevices.h"
#include "utils/HArray.h"
#include "HIDAcme.h"
#include "HIDSocket.h"
#include "HEXFile.h"
#include <time.h>
#ifndef _WIN32
#include <termio.h>
#endif

char mygetch()
{
#ifdef _WIN32
	return getch();
#else
	struct termios new_settings, stored_settings;
	tcgetattr(0,&stored_settings);
	new_settings = stored_settings;
	new_settings.c_lflag &= (~ICANON);
	new_settings.c_cc[VTIME] = 0;
	tcgetattr(0,&stored_settings);
	new_settings.c_cc[VMIN] = 1;
	tcsetattr(0,TCSANOW,&new_settings);
	
	char ch = getchar();
	
	tcsetattr(0,TCSANOW,&stored_settings);
	
	return ch;
#endif
}

int main(int argc, char* argv[])
{
	printf("ITUNER HIDBlinker ver 1.0.0.0\n");

	char manuf[HID_STR_LEN];strcpy(manuf, MANUFACTURER);
	char prod_lcd[HID_STR_LEN];strcpy(prod_lcd, PROD_LCD);
	char prod_flash[HID_STR_LEN];strcpy(prod_flash, PROD_FLASH);
	unsigned short vendor = 0x4d8;
//	unsigned short pid = 0x2;
	int timeout = 5000;
	char* root_path = NULL;//used only for linux version
		
	bool help   = false;
	int ir_decoder = IR_UNKNOWN;
	int devno   = -1;

	int ton  = 10000;
	int toff = 30000;
	if (argc>0)
	{
		int i = 1;
		while (i<argc)
		{
			if (strcmp(argv[i], "-ton")==0)
			{
				i++;
				ton = atoi(argv[i]);
				if (ton < 10) ton = 10;
			}
			else if (strcmp(argv[i], "-toff")==0)
			{
				i++;
				toff = atoi(argv[i]);
				if (toff < 10) toff = 10;
			}
			else if (strcmp(argv[i], "-manuf")==0)
			{
				i++;
				strcpy(manuf, argv[i]);
			}
			else if (strcmp(argv[i], "-prodlcd")==0)
			{
				i++;
				strcpy(prod_lcd, argv[i]);
			}
			else if (strcmp(argv[i], "-prodflash")==0)
			{
				i++;
				strcpy(prod_flash, argv[i]);
			}
			else if (strcmp(argv[i], "-vendor")==0)
			{
				i++;
				vendor = atoi(argv[i]);
			}
//			else if (strcmp(argv[i], "-pid")==0)
//			{
//				i++;
//				pid = atoi(argv[i]);
//			}
			else if (strcmp(argv[i], "-dbg")==0)
			{
				i++;
				SetDbgLevel(atoi(argv[i]));
			}
			else if (strcmp(argv[i], "-tout")==0)
			{
				i++;
				timeout = atoi(argv[i]);
			}
			else if (strcmp(argv[i], "-devno")==0)
			{
				i++;
				devno = atoi(argv[i]);
			}
#ifndef _WIN32
			else if (strcmp(argv[i], "-root")==0)
			{
				i++;
				root_path = argv[i];
			}
#endif			
			else 
			{
				printf("Invalid parameter %s\n", argv[i]);
				help = true;
			}

			i++;
		}
	}

	if (help)
	{
		printf("Possible parameters:\n");
		//printf("-expert         - expert mode\n");
		printf("-ton       int    - max ON time of the leds (randomized)\n");
		printf("-toff      int    - max OFF time of the leds (randomized)\n");
		printf("-manuf     string - manufacturer \n");
		printf("-prodlcd   string - product name in LCD mode\n");
		printf("-prodflash string - product name in FLASH mode\n");
		printf("-vendor    ushort - vendor id\n");
		//printf("-pid     ushort - product id\n");
		printf("-dbg       ushort - debug level\n");
		printf("-tout      int    - timeout when switching between two modes\n");
		printf("-devno     ushort - device number if more present (1,2,3)\n");
#ifndef _WIN32
		printf("-root    string - root path of hid devices (/hid/hiddev) \n");
#endif
		printf("Press any key ...\n");mygetch();
		return 0;
	}

	MyTrace(0, "Manuf:%s Prod:%s/%s vendor=%x pid=%x,%x \n",manuf, prod_lcd, prod_flash, vendor, 0x1,0x2); 
	MyTrace(0, "Blinker: TON=%dms TOFF=%dms\n",ton, toff); 

	HIDDevices hdevs;
#ifndef _WIN32
	hdevs.setRootPath(root_path);
#endif

	HIDDescriptor* hdesc = hdevs.chooseHIDDevice(manuf, prod_lcd, prod_flash, vendor, -1, devno);
	if (hdesc)
	{
		MyTrace(1, "You choose %s\n", hdesc->GetHIDPath());

		HIDDevice* dev = hdevs.openDevice(hdesc);
		HIDAcme acme(dev, timeout, ir_decoder);

		acme.setText(0,0,"PicoLCD 2x20 Blinker");
		acme.setText(0,1,"  www.mini-box.com  ");
		
		MyTrace(0, "\nPress any key to exit ...\n");

		DWORD tme1 = GetTickCount();
		bool  state[8];
		DWORD switcht[8];
		int i = 0;
		DWORD dw = 0;

		srand((unsigned)time( NULL ));

		dw = GetTickCount();	
		for (i=0;i<8;i++)
		{
			state[i]	= false;
			switcht[i]	= dw + (ton * rand()/RAND_MAX);
			if (switcht[i] < dw) switcht[i] = dw | 0xFF;
		}
		
		bool changed = false;
		acme.setLedStatus(0);
		
		do
		{
			dw = GetTickCount();

			changed = false;

			for (i=0;i<8;i++)
			{
				if (dw >= switcht[i])
				{
					state[i] = !state[i];

					if (state[i])
						 switcht[i] = dw + (ton * rand()/RAND_MAX);
					else switcht[i] = dw + (toff * rand()/RAND_MAX);

					if (switcht[i] < dw) switcht[i] = dw | 0xFF;

					//printf("[%d]=%d on=%d\n",i,switcht[i]-dw,state[i]);

					changed = true;
				}
			}

			if (changed)
			{
				unsigned char led = 0;
				for (i=0;i<8;i++)
				{
					if (state[i]) led = led | (1 << i);
				}
				//printf("         led=%x\n",led);
				acme.setLedStatus(led);
			}

			Sleep(10);
		}while (!kbhit());

		MyTrace(0, "Exiting. Please wait ...\n");
		delete dev;
	}

	return 0;
}
