// HIDClient.cpp: implementation of the HIDClient class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HIDClient.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

HIDClient::HIDClient(HSocket* sock, HIDSocket* parent)
{
	m_pSocket = sock;
	m_pParent = parent;
	m_bGarbage = false;
	start();
}

HIDClient::~HIDClient()
{
	m_pSocket->setStatus(-1);
	stop();
	delete m_pSocket;
}

void HIDClient::run()
{
	const int intSize = 10000;
	char a[intSize];

	bool dropped = false;

	while( m_pSocket->getStatus()==0 && isRunning())
	{
		int size=m_pSocket->getLine( a,intSize );
		if( size < 0 )
		{
			MyTrace(0, "CLIENT disconnected from IP %s\n", m_pSocket->GetIP() );
			m_pSocket->setStatus(-1);
			dropped = true;
		}
		else if (size != 0)
		{
			a[size] = 0;
			printf( "S_RX(%s):%s\n" , m_pSocket->GetIP(), a);
			m_pParent->sendCmd(this, a);
		}

		Sleep(10);
	}

	MyTrace(0, "   Exiting thread %s\n",m_pSocket->GetIP());

	m_bGarbage = true;
}