// HIDClient.h: interface for the HIDClient class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HIDCLIENT_H__2D20A341_59BF_43A7_B9D7_B1FFA5653DCB__INCLUDED_)
#define AFX_HIDCLIENT_H__2D20A341_59BF_43A7_B9D7_B1FFA5653DCB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "utils/HSocket.h"
#include "utils/HThread.h"
#include "HIDSocket.h"

#ifdef HIDAPI_EXPORTS
class HIDAPI_API HIDClient : public HThread 
#else
class HIDClient : public HThread
#endif
{
public:
	HIDClient(HSocket* sock, HIDSocket* parent);
	virtual ~HIDClient();

	bool isGarbage(){return m_bGarbage;};

	virtual void run();

	HSocket* getSocket(){return m_pSocket;};

private:
	HSocket* m_pSocket;

	HIDSocket* m_pParent;

	struct sockaddr_in m_sad;

	bool m_bGarbage;//true after user disconnects
};

#endif // !defined(AFX_HIDCLIENT_H__2D20A341_59BF_43A7_B9D7_B1FFA5653DCB__INCLUDED_)
