// HIDDaemon.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "HIDDevices.h"
#include "utils/HArray.h"
#include "HIDAcme.h"
#include "HIDSocket.h"
#include "HEXFile.h"
#ifndef _WIN32
#include <termio.h>
#endif

char mygetch()
{
#ifdef _WIN32
	return getch();
#else
	struct termios new_settings, stored_settings;
	tcgetattr(0,&stored_settings);
	new_settings = stored_settings;
	new_settings.c_lflag &= (~ICANON);
	new_settings.c_cc[VTIME] = 0;
	tcgetattr(0,&stored_settings);
	new_settings.c_cc[VMIN] = 1;
	tcsetattr(0,TCSANOW,&new_settings);
	
	char ch = getchar();
	
	tcsetattr(0,TCSANOW,&stored_settings);
	
	return ch;
#endif
}

void expertRun(int timeout, char* root_path, int ir_decoder)
{
	HIDDevices hdevs;
#ifndef _WIN32
	hdevs.setRootPath(root_path);
#endif
	
	char ch = 0;
	do{
		printf("-----------------------------------\n");
		printf("Press a key:\n");
#ifdef _WIN32
		printf("1: enumerate all USB devices\n");
#endif
		printf("2: enumerate HID devices (DDK stuff)\n");
		printf("3: choose HID device to communicate\n");
		printf("4: load hex file\n");
		printf("5: open ACME device and communicate\n");
		printf("<ESC>: exit\n");
		printf("-----------------------------------\n");

		ch = mygetch();
		switch (ch)
		{
#ifdef _WIN32
		case '1':hdevs.enumerateUSBDevices();break;
#endif
		case '2':hdevs.enumerateHIDDevices();break;
		case '3':
		case '5':
			{
				HIDDescriptor* hdesc;
				
				if (ch == '3') hdesc = hdevs.chooseHIDDevice(NULL, NULL, NULL, 0, 0);
				else hdesc = hdevs.chooseHIDDevice(MANUFACTURER, PROD_LCD, PROD_FLASH, 0x4d8, -1);

				if (hdesc)
				{
					printf("You choose %s\n", hdesc->GetHIDPath());

					HIDDevice* dev = hdevs.openDevice(hdesc);

					if (dev)
					{
						HIDAcme acme(dev, timeout, ir_decoder);

						char ch2 = 0;
						do{
							printf("-----------------------------------\n");
							printf("Press a key:\n");
							printf("1: Led status loop\n");
							printf("2: Backlight on\n");
							printf("3: Backlight off\n");
							printf("4: Contrast\n");
							printf("5: Text\n");
							printf("6: Send flash file:MCHPUSB.hex\n");
							printf("7: Switch mode\n");
							printf("8: Read file: read.hex\n");
							printf("9: Read eprom: eprom_read.hex\n");
							printf("<ESC>: stop device communication\n");
							printf("-----------------------------------\n");

							ch2 = mygetch();
							switch (ch2)
							{
							case '1':
								{
									unsigned char stat = 1;
									for (int i=0;i<9;i++)
									{
										acme.setLedStatus(stat);
										stat = stat << 1;
									}
								}break;
							case '2':acme.setBacklight(0x01);break;
							case '3':acme.setBacklight(0x00);break;
							case '4':
								{
									for (unsigned char i=0x40;i>0;i-=0x10)
									{
										acme.setContrast(i);
										Sleep(10);
									}
								}break;
							case '5':
								{
									for (int i=0;i<2*0x14;i++)
									{
										acme.setText(i%0x14, i/0x14, "*");
										Sleep(50);
										//acme.setText(i/0x14, i%0x14, " ");
										acme.clearLCD();
									}
								}break;
							case '6':
								{
									acme.writeFile(false, TYPE_CODE_MEMORY, "MCHPUSB.hex", -1);
								}break;
							case '7':
								{
									acme.switchMode();
								}break;
							case '8':
								{
									acme.readFile(false, TYPE_CODE_MEMORY, "read.hex",0x2000,0x8000);
								}break;
							case '9':
								{
									acme.readFile(false, TYPE_EPROM_EXTERNAL, "eprom_read.hex",0x0,0x2000);
								}break;
							}
						}while(ch2 != 27);
						delete dev;
					}
					else printf("Invalid device\n");
				}
				else printf("Invalid device\n");
			}break;
		case '4':
			{
				printf("Loading hex file\n");
				HEXFile hfile("MCHPUSB.hex");
				if (hfile.Open() == 0)
				{
					while (hfile.NextLine()==0);
				}
				else printf("File not found\n");
				hfile.Close();
			}break;
		}
	}while(ch != 27);
}

int main(int argc, char* argv[])
{
	printf("ITUNER HIDDaemon ver 1.0.0.16\n");

	char manuf[HID_STR_LEN];strcpy(manuf, MANUFACTURER);
	char prod_lcd[HID_STR_LEN];strcpy(prod_lcd, PROD_LCD);
	char prod_flash[HID_STR_LEN];strcpy(prod_flash, PROD_FLASH);
	unsigned short vendor = 0x4d8;
//	unsigned short pid = 0x2;
	int port = 10000;
	int timeout = 5000;
	char* root_path = NULL;//used only for linux version
		
	bool expert = false;
	bool help   = false;
	int ir_decoder = IR_UNKNOWN;
	int devno   = -1;
	if (argc>0)
	{
		int i = 1;
		while (i<argc)
		{
			if (strcmp(argv[i], "-expert")==0)
				expert = true;
			else if (strcmp(argv[i], "-manuf")==0)
			{
				i++;
				strcpy(manuf, argv[i]);
			}
			else if (strcmp(argv[i], "-prodlcd")==0)
			{
				i++;
				strcpy(prod_lcd, argv[i]);
			}
			else if (strcmp(argv[i], "-prodflash")==0)
			{
				i++;
				strcpy(prod_flash, argv[i]);
			}
			else if (strcmp(argv[i], "-vendor")==0)
			{
				i++;
				vendor = atoi(argv[i]);
			}
//			else if (strcmp(argv[i], "-pid")==0)
//			{
//				i++;
//				pid = atoi(argv[i]);
//			}
			else if (strcmp(argv[i], "-dbg")==0)
			{
				i++;
				SetDbgLevel(atoi(argv[i]));
			}
			else if (strcmp(argv[i], "-port")==0)
			{
				i++;
				port = atoi(argv[i]);
			}
			else if (strcmp(argv[i], "-tout")==0)
			{
				i++;
				timeout = atoi(argv[i]);
			}
			else if (strcmp(argv[i], "-devno")==0)
			{
				i++;
				devno = atoi(argv[i]);
			}
			else if (strcmp(argv[i], "-ir")==0)
			{
				i++;
				if (  (strcmp("rc5", argv[i])==0)
					||(strcmp("1", argv[i])==0))
				{
					ir_decoder = IR_RC5;
				}

			}
#ifndef _WIN32
			else if (strcmp(argv[i], "-root")==0)
			{
				i++;
				root_path = argv[i];
			}
#endif			
			else 
			{
				printf("Invalid parameter %s\n", argv[i]);
				help = true;
			}

			i++;
		}
	}

	if (help)
	{
		printf("Possible parameters:\n");
		//printf("-expert         - expert mode\n");
		printf("-manuf     string - manufacturer \n");
		printf("-prodlcd   string - product name in LCD mode\n");
		printf("-prodflash string - product name in FLASH mode\n");
		printf("-vendor    ushort - vendor id\n");
		//printf("-pid     ushort - product id\n");
		printf("-dbg       ushort - debug level\n");
		printf("-port      int    - server socket port\n");
		printf("-tout      int    - timeout when switching between two modes\n");
		printf("-devno     ushort - device number if more present (1,2,3)\n");
		printf("-ir        string - ir decoder type (rc5 or 1=RC5, anything else no decoding\n");
#ifndef _WIN32
		printf("-root    string - root path of hid devices (/hid/hiddev) \n");
#endif
		printf("Press any key ...\n");mygetch();
		return 0;
	}

	HSocket::initSocketLibrary(2,0);

	if (expert)
	{
		printf("EXPERT MODE!\n");
		expertRun(timeout, root_path, ir_decoder);
	}
	else
	{
		MyTrace(0, "Manuf:%s Prod:%s/%s vendor=%x pid=%x,%x TCP/IP port:%d\n",manuf, prod_lcd, prod_flash, vendor, 0x1,0x2, port); 

		HIDDevices hdevs;
#ifndef _WIN32
		hdevs.setRootPath(root_path);
#endif
		HIDDescriptor* hdesc = hdevs.chooseHIDDevice(manuf, prod_lcd, prod_flash, vendor, -1, devno);
		if (hdesc)
		{
			MyTrace(1, "You choose %s\n", hdesc->GetHIDPath());

			HIDDevice* dev = hdevs.openDevice(hdesc);
			HIDAcme acme(dev, timeout, ir_decoder);
			
			HIDSocket sock(&acme, port);

			char buf[256];
			do
			{
				printf("Cmd:");
				gets(buf);
				if (buf[0] != 0)
				{
					acme.sendCmd(buf, false);
				}
			}while (buf[0] != 0);

			MyTrace(0, "Exiting. Please wait ...\n");
			delete dev;
		}
		else
		{
#ifdef _DEBUG
			HIDAcme acme(NULL, timeout, ir_decoder);
			HIDSocket sock(&acme, port);

			char buf[256];
			do
			{
				printf("Cmd:");
				gets(buf);
				if (buf[0] != 0)
				{
					//sock.send2all(buf);
					acme.sendCmd(buf, false);
				}
			}while (buf[0] != 0);
#else
			printf("Press any key ...\n");mygetch();
#endif
		}
	}

	HSocket::closeSocketLibrary();

	return 0;
}
