// HIDFlashDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HIDFlash.h"
#include "HIDFlashDlg.h"
#include "ReadMinMax.h"
#include "CompareDlg.h"
#include "CompareResult.h"
#include "EpromChooser.h"
#include "WriteEprom.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHIDFlashDlg dialog

CHIDFlashDlg::CHIDFlashDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHIDFlashDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHIDFlashDlg)
	m_strManuf = _T(MANUFACTURER);
	m_strVendor = _T("4d8");
	m_strDevice = _T("");
	m_nPort = 0;
	m_nDbg = 0;
	m_strMsgs = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAcme = NULL;
	m_pSocket = NULL;
	m_pDev = NULL;

	m_bConnected = false;
	m_nPort = 10000;

	m_nTimeout = 5000;
	m_nIrDecoder = IR_UNKNOWN;

#ifdef _DEBUG
	m_nDbg = 5;
#endif

	HSocket::initSocketLibrary(2,0);
}

CHIDFlashDlg::~CHIDFlashDlg()
{
	if (m_pAcme)
		m_pAcme->SetSocket(NULL);

	if (m_pSocket)
	{
		delete m_pSocket;
		m_pSocket = NULL;
	}

	if (m_pAcme)
	{
		delete m_pAcme;
		m_pAcme = NULL;
	}

	if (m_pDev)
	{
		delete m_pDev;
		m_pDev = NULL;
	}

	HSocket::closeSocketLibrary();
}

void CHIDFlashDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHIDFlashDlg)
	DDX_Control(pDX, IDC_EDIT_LOG, m_eMsgs);
	DDX_Control(pDX, IDC_STATIC_ACTION, m_sAction);
	DDX_Control(pDX, IDC_PROGRESSBAR, m_pBar);
	DDX_Control(pDX, IDC_STATIC_FLASH, m_bFlashText);
	DDX_Text(pDX, IDC_EDIT_MANUF, m_strManuf);
	DDX_Text(pDX, IDC_EDIT_VENDOR, m_strVendor);
	DDX_Text(pDX, IDC_STATIC_DEVICE, m_strDevice);
	DDX_Text(pDX, IDC_EDIT_PORT, m_nPort);
	DDX_CBIndex(pDX, IDC_COMBO_DBG, m_nDbg);
	DDX_Text(pDX, IDC_EDIT_LOG, m_strMsgs);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CHIDFlashDlg, CDialog)
	//{{AFX_MSG_MAP(CHIDFlashDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_WRITEFILE, OnButtonWritefile)
	ON_BN_CLICKED(IDC_BUTTON_ERASE, OnButtonErase)
	ON_BN_CLICKED(IDC_BUTTON_READ, OnButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_COMPARE, OnButtonCompare)
	ON_BN_CLICKED(IDC_BUTTON_SWITCH, OnButtonSwitch)
	ON_CBN_SELCHANGE(IDC_COMBO_DBG, OnSelchangeComboDbg)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER  , OnConnected)
	ON_MESSAGE(WM_USER+1, OnTrace)
END_MESSAGE_MAP()

void CHIDFlashDlg::AddMesg(CString str)
{
	str.Replace("\n","\r\n");

	m_strMsgs += str;

	if (m_strMsgs.GetLength() > 2000)
		m_strMsgs = m_strMsgs.Right(2000);

	if (GetSafeHwnd()) 
		PostMessage(WM_USER+1);
}

long CHIDFlashDlg::OnTrace(WPARAM uID, LPARAM lParam)
{
	UpdateData(FALSE);
/*	while (m_lMesgs.GetCount()>100)
		m_lMesgs.DeleteItem(0);

	m_lMesgs.AddString(m_strMesg);
	m_lMesgs.SetCurSel(m_lMesgs.GetCount()-1);*/

	m_eMsgs.LineScroll(500);

	return 0;
}
/////////////////////////////////////////////////////////////////////////////
// CHIDFlashDlg message handlers

BOOL CHIDFlashDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	SetDbLevel(m_nDbg);

	Connect();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CHIDFlashDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CHIDFlashDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CHIDFlashDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CHIDFlashDlg::OnOK() 
{
//	CDialog::OnOK();
}

void CHIDFlashDlg::Connect() 
{
	UpdateData(TRUE);

	if (!m_pAcme)
	{
		GetDlgItem(IDC_BUTTON_WRITEFILE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_ERASE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_READ)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_COMPARE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_SWITCH)->EnableWindow(FALSE);

		if (m_pSocket)
		{
			delete m_pSocket;
			m_pSocket = NULL;
		}

		m_strDevice = "";

		int vendor = strtol(m_strVendor, NULL, 16);
		
		HIDDescriptor* hdesc = m_devices.chooseHIDDevice(m_strManuf, PROD_LCD, PROD_FLASH, vendor, -1);
		MyTrace(0, "hdesc=%x\n",hdesc);
		if (hdesc)
		{
	//		MyTrace(1, "You choose %s\n", hdesc->m_interfaceDetailData->DevicePath);
	//		m_pAcme = m_devices.openAcme(hdesc, this);

			m_pDev = m_devices.openDevice(hdesc);
			m_pAcme = new HIDAcme(m_pDev, m_nTimeout, m_nIrDecoder);
			m_pAcme->connectGraph(this);

			MyTrace(0, " dev=%x acme=%x\n",m_pDev, m_pAcme);


			GetDlgItem(IDC_EDIT_PORT)->EnableWindow(FALSE);
			GetDlgItem(IDC_EDIT_MANUF)->EnableWindow(FALSE);
			GetDlgItem(IDC_EDIT_VENDOR)->EnableWindow(FALSE);

			m_strDevice = CString(hdesc->m_sProduct);
			
			if (m_pAcme->isFlasher())
			{
				GetDlgItem(IDC_BUTTON_WRITEFILE)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON_ERASE)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON_READ)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON_COMPARE)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON_SWITCH)->EnableWindow(TRUE);

				GetDlgItem(IDC_BUTTON_SWITCH)->SetWindowText("Switch: keyb");

				m_bFlashText.SetWindowText("FLASH enabled/EPROM disabled");
			}
			else
			{
				m_pSocket = new HIDSocket(m_pAcme, m_nPort);
				m_bFlashText.SetWindowText("FLASH disabled/EPROM enabled");

				GetDlgItem(IDC_BUTTON_WRITEFILE)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON_READ)->EnableWindow(TRUE);
				GetDlgItem(IDC_BUTTON_COMPARE)->EnableWindow(TRUE);

				GetDlgItem(IDC_BUTTON_SWITCH)->EnableWindow(TRUE);
				
				GetDlgItem(IDC_BUTTON_SWITCH)->SetWindowText("Switch: flasher");
			}
		}
	}
	else AfxMessageBox("Already connected\n");

	UpdateData(FALSE);
}

long CHIDFlashDlg::OnConnected(WPARAM uID, LPARAM lParam)
{

	return 0;
}

void CHIDFlashDlg::UpdateStatus(bool fromsocket, int type, int n1, int n2)
{
	TRACE("%x %d %d\n", type, n1, n2);
	switch (type)
	{
	case STATUS_ERASE:
		{
			CString str;
			str.Format("Erasing %d from %d",n2,n1);
			m_sAction.SetWindowText(str);
			m_pBar.SetRange(0, n1);
			m_pBar.SetPos(n2);
		}break;
	case STATUS_WRITE:
		{
			CString str;
			str.Format("Writing %d from %d",n2,n1);
			m_sAction.SetWindowText(str);
			m_pBar.SetRange(0, n1);
			m_pBar.SetPos(n2);
		}break;
	case STATUS_READ:
		{
			CString str;
			str.Format("Reading %d from %d",n2,n1);
			m_sAction.SetWindowText(str);
			m_pBar.SetRange(0, n1);
			m_pBar.SetPos(n2);
		}break;
	case STATUS_OK:
		{
			CString str = "OK: UNKNOWN";

			switch (n1)
			{
			case STATUS_ERASE:
				{
					str = "Status: Erasing completed";
				}break;
			case STATUS_WRITE:
				{
					str = "Status: File write completed";
				}break;
			case STATUS_READ:
				{
					str = "Status: Memory read completed";
				}break;
			}

			if (fromsocket)
				 AddMesg(str+"\n");
			else AfxMessageBox(str);

			m_sAction.SetWindowText("");
			m_pBar.SetPos(0);
		}break;
	case STATUS_ERROR:
		{
			CString str = "ERROR: UNKNOWN";
			switch (n1)
			{
			case STATUS_ERASE:
				{
					str.Format("ERROR: Erasing flash %d",n2);
				}break;
			case STATUS_WRITE:
				{
					str.Format("ERROR: File write %d",n2);
				}break;
			case STATUS_READ:
				{
					str.Format("ERROR: Memory read %d",n2);
				}break;
			}

			if (fromsocket)
				 AddMesg(str+"\n");
			else AfxMessageBox(str);

			m_sAction.SetWindowText("");
			m_pBar.SetPos(0);
		}break;
	}
}

void CHIDFlashDlg::OnButtonWritefile() 
{
	if (!m_pAcme)
	{
		AfxMessageBox("Connect first!");
		return;
	}
//	if (!m_pAcme->isFlasher())
//	{
//		AfxMessageBox("Device in keyboard mode\nFlashing not allowed!");
//		return;
//	}

	unsigned long writeeprom = -1;
	int etype = -1;
	if (!m_pAcme->isFlasher())
	{
		CEpromChooser dlg(this);
		if (dlg.DoModal() != IDOK) return;

		if (!dlg.m_internal)
			etype = TYPE_EPROM_INTERNAL;
		else 
			etype = TYPE_EPROM_EXTERNAL;
	}
	else
	{
		CWriteEprom dlg(this);

		if (dlg.DoModal() == IDOK) writeeprom = -1;
		else writeeprom = 0xF000;
	}
	
	char BASED_CODE szFilter[] = "Hex files (*.hex)|*.hex|";
	CFileDialog cfd(TRUE,NULL,"*.hex", OFN_OVERWRITEPROMPT | OFN_EXPLORER,  szFilter,this);
	if (cfd.DoModal()==IDOK)
	{
		RedrawWindow();

		CString file = cfd.GetPathName();

		CWaitCursor cursor;

		if (m_pAcme->isFlasher())
			 m_pAcme->writeFile(false, TYPE_CODE_MEMORY, file, writeeprom);
		else m_pAcme->writeFile(false, etype, file, writeeprom);
	}
}

void CHIDFlashDlg::OnButtonErase() 
{
	if (!m_pAcme)
	{
		AfxMessageBox("Connect first!");
		return;
	}
	if (!m_pAcme->isFlasher())
	{
		AfxMessageBox("Device in keyboard mode\nFlashing not allowed!");
		return;
	}

	CReadMinMax read(this);
	read.m_strMemMax = "x8000";
	read.m_strMemMin = "x2000";
	if (read.DoModal() == IDOK)
	{
		unsigned long start = getno(read.m_strMemMin);
		unsigned long end = getno(read.m_strMemMax);

		RedrawWindow();

		CWaitCursor cursor;

		m_pAcme->eraseFlash(false, start, end);
	}
}

void CHIDFlashDlg::OnButtonRead() 
{
	if (!m_pAcme)
	{
		AfxMessageBox("Connect first!");
		return;
	}
//	if (!m_pAcme->isFlasher())
//	{
//		AfxMessageBox("Device in keyboard mode\nFlashing not allowed!");
//		return;
//	}

	int etype = -1;
	if (!m_pAcme->isFlasher())
	{
		CEpromChooser dlg(this);
		if (dlg.DoModal() != IDOK) return;

		if (!dlg.m_internal)
			etype = TYPE_EPROM_INTERNAL;
		else 
			etype = TYPE_EPROM_EXTERNAL;
	}

	
	char BASED_CODE szFilter[] = "Hex files (*.hex)|*.hex|";
	CFileDialog cfd(FALSE,NULL,"read.hex", OFN_OVERWRITEPROMPT | OFN_EXPLORER,  szFilter,this);
	if (cfd.DoModal()==IDOK)
	{
		CReadMinMax read(this);
		if (m_pAcme->isFlasher())
		{
			read.m_strMemMax = "x8000";
			read.m_strMemMin = "x2000";
		}
		else
		{
			read.m_strMemMax = "x2000";
			read.m_strMemMin = "x0000";
		}

		if (read.DoModal()==IDOK)
		{
			unsigned long start = getno(read.m_strMemMin);
			unsigned long end = getno(read.m_strMemMax);

			if (start >= end)
			{
				AfxMessageBox("Start or end address eronated! (start>=end)");
				return;
			}


			RedrawWindow();

			CString file = cfd.GetPathName();

			CWaitCursor cursor;

			if (m_pAcme->isFlasher())
				 m_pAcme->readFile(false, TYPE_CODE_MEMORY, file, start, end);
			else m_pAcme->readFile(false, etype, file, start, end);
		}
	}
}


void CHIDFlashDlg::OnButtonCompare() 
{
	if (!m_pAcme)
	{
		AfxMessageBox("Connect first!");
		return;
	}
//	if (!m_pAcme->isFlasher())
//	{
//		AfxMessageBox("Device in keyboard mode\nFlashing not allowed!");
//		return;
//	}

	int etype = -1;
	if (!m_pAcme->isFlasher())
	{
		CEpromChooser dlg(this);
		if (dlg.DoModal() != IDOK) return;

		if (!dlg.m_internal)
			etype = TYPE_EPROM_INTERNAL;
		else 
			etype = TYPE_EPROM_EXTERNAL;
	}

	CCompareDlg read(this);
	if (m_pAcme->isFlasher())
	{
		read.m_strMax = "x8000";
		read.m_strMin = "x2000";
	}
	else
	{
		read.m_strMax = "x2000";
		read.m_strMin = "x0000";
	}
	if (read.DoModal() == IDOK)
	{
		unsigned long start = getno(read.m_strMin);
		unsigned long end = getno(read.m_strMax);

		if (start >= end)
		{
			AfxMessageBox("Start or end address eronated! (start>=end)");
			return;
		}

		if (read.m_bFromDev)
		{
			RedrawWindow();

			CString file = read.m_strFile1;

			CWaitCursor cursor;

			if (m_pAcme->isFlasher())
				 m_pAcme->readFile(false, TYPE_CODE_MEMORY, file, start, end);
			else m_pAcme->readFile(false, etype, file, start, end);
		}

		//comparing two files
		unsigned char* data1 = new unsigned char[end];
		unsigned char* data2 = new unsigned char[end];

		if (!m_pAcme->loadFile2Array(data1, end, read.m_strFile1))
		{
			AfxMessageBox("Cannot load file 1");
		}
		else
		{
			if (!m_pAcme->loadFile2Array(data2, end, read.m_strFile2))
			{
				AfxMessageBox("Cannot load file 2");
			}
			else
			{
				if (read.m_bWriteDump)
				{
					FILE* f1 = fopen("f1.txt", "wt");
					if (f1)
					{
						fprintf(f1, "%s\n", read.m_strFile1);
						for (unsigned long i=0;i<end;i++)
						{
							if ((i % 32) == 0) fprintf(f1, "\n%08X: ", i);
							fprintf(f1, "%02X", data1[i]);
						}
						fclose(f1);
					}

					FILE* f2 = fopen("f2.txt", "wt");
					if (f2)
					{
						fprintf(f2, "%s\n", read.m_strFile2);
						for (unsigned long i=0;i<end;i++)
						{
							if ((i % 32) == 0) fprintf(f1, "\n%08X: ", i);
							fprintf(f2, "%02X", data2[i]);
						}
						fclose(f2);
					}		
				}

				int cnt = 0;
				CString str = "",tmp;
				for (unsigned long i=0;i<end;i++)
				{
					if (data1[i] != data2[i])
					{
						if (cnt < 15)
						{
							tmp.Format("[%08X] %02X != %02X\r\n",i, data1[i], data2[i]);
							str += tmp;
							cnt++;
						}
						else
						{
							str += "More than 15 differences found\r\nComparing stopped!\n";
							i = end;
						}
					}
				}

				if (str == "") str = "The two files are identical!";

				CCompareResult comp(this);
				comp.m_strText = str;
				comp.DoModal();
			}
		}

		delete data1;
		delete data2;
	}
}

void CHIDFlashDlg::OnButtonSwitch() 
{
	if (!m_pAcme)
	{
		AfxMessageBox("Connect first!");
		return;
	}
	
	int res = AfxMessageBox("Are you sure you want to switch the mode?", MB_YESNO|MB_ICONSTOP);
	if (res == IDYES)
	{
		CWaitCursor cursor;

		if (m_pSocket)
		{
			delete m_pSocket;
			m_pSocket = NULL;
		}

		m_pAcme->switchMode();

		if (m_pAcme) delete m_pAcme;
		m_pAcme = NULL;
		if (m_pDev) delete m_pDev;
		m_pDev = NULL;

		Sleep(m_nTimeout+1000);

//		AfxMessageBox("You have to restart the program!");
//		OnCancel();
		for (int i=0;i<5;i++)
		{
			m_strDevice.Format("Reconnecting %d ...",i);
			UpdateData(FALSE);
			RedrawWindow();

			if (m_pAcme) delete m_pAcme;
			m_pAcme = NULL;
			if (m_pDev) delete m_pDev;
			m_pDev = NULL;

			Connect();

			if ((m_pAcme != NULL)&&(m_pAcme->isWOK()))
			{
				TRACE("Connected \n");
				i = 100;
			}
			else
			{
				TRACE("Not Connected %d\n", i);
				Sleep(2000);
			}
		}

		UpdateData(FALSE);
		RedrawWindow();

		if (m_pAcme && m_pAcme->isWOK())
		{
			//connected
		}
		else
		{
			m_strDevice.Format("Reconnecting FINAL ...");//,i);
			UpdateData(FALSE);
			RedrawWindow();

			if (m_pAcme) delete m_pAcme;
			m_pAcme = NULL;
			if (m_pDev) delete m_pDev;
			m_pDev = NULL;

			Connect();

			if (!m_pAcme)
			{
				AfxMessageBox("Device could not be restarted! The program has to be restarted!");
				//EndDialog(0);
			}
		}
	}
}

void CHIDFlashDlg::OnSelchangeComboDbg() 
{
	UpdateData(TRUE);
	SetDbLevel(m_nDbg);
}

void CHIDFlashDlg::SetDbLevel(int dbg)
{
	if (GetSafeHwnd())
	{
		CRect rect;
		GetWindowRect(&rect);

		if (m_nDbg)
			rect.bottom = rect.top+340;
		else
			rect.bottom = rect.top+220;

		MoveWindow(rect);
	}
	SetDbgLevel(m_nDbg);
}
