// HIDFlashDlg.h : header file
//

#if !defined(AFX_HIDFLASHDLG_H__F1C61D4F_EE75_4417_990E_254A363C6F8D__INCLUDED_)
#define AFX_HIDFLASHDLG_H__F1C61D4F_EE75_4417_990E_254A363C6F8D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "../HIDDevices.h"
#include "../HIDGraphics.h"
#include "../HIDAcme.h"
#include "../HIDSocket.h"
#include "../utils/HSocket.h"
/////////////////////////////////////////////////////////////////////////////
// CHIDFlashDlg dialog

class CHIDFlashDlg : public CDialog, HIDGraphics
{
// Construction
public:
	CHIDFlashDlg(CWnd* pParent = NULL);	// standard constructor
	virtual ~CHIDFlashDlg();

// Dialog Data
	//{{AFX_DATA(CHIDFlashDlg)
	enum { IDD = IDD_HIDFLASH_DIALOG };
	CEdit	m_eMsgs;
	CStatic	m_sAction;
	CProgressCtrl	m_pBar;
	CButton	m_bFlashText;
	CString	m_strManuf;
	CString	m_strVendor;
	CString	m_strDevice;
	int		m_nPort;
	int		m_nDbg;
	CString	m_strMsgs;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHIDFlashDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual void UpdateStatus(bool fromsocket, int type, int n1, int n2);
	void AddMesg(CString str);

	int m_nTimeout;
	int m_nIrDecoder;
protected:
	void Connect();
	bool m_bConnected;

	void SetDbLevel(int dbg);

	HIDDevices m_devices;
	HIDAcme* m_pAcme;
	HIDDevice* m_pDev;
	HIDSocket* m_pSocket;

	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CHIDFlashDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	afx_msg void OnButtonWritefile();
	afx_msg void OnButtonErase();
	afx_msg void OnButtonRead();
	afx_msg void OnButtonCompare();
	afx_msg void OnButtonSwitch();
	afx_msg void OnSelchangeComboDbg();
	//}}AFX_MSG
	afx_msg long OnConnected(WPARAM uID, LPARAM lParam);
	afx_msg long OnTrace(WPARAM uID, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_HIDFLASHDLG_H__F1C61D4F_EE75_4417_990E_254A363C6F8D__INCLUDED_)
