// HIDSocket.h: interface for the HIDSocket class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HIDSOCKET_H__5517669B_1125_4FD4_AB2D_E421415083B3__INCLUDED_)
#define AFX_HIDSOCKET_H__5517669B_1125_4FD4_AB2D_E421415083B3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "utils/HServerSock.h"
#include "utils/HThread.h"
#include "utils/HList.h"

class HIDAcme;
class HIDClient;
class HGarbageCollector;

#ifdef HIDAPI_EXPORTS
class HIDAPI_API HIDSocket : private HThread
#else
class HIDSocket : private HThread
#endif
{
public:
	HIDSocket(HIDAcme* device, int port);
	virtual ~HIDSocket();

	void send2all(const char* msg);
	void sendCmd(HIDClient* client, const char* cmd);

	friend class HGarbageCollector;

private:
	void send2one(HSocket* sock, const char* msg);
	void connected(HSocket* sock);

	virtual void run( void );

	HServerSock* m_pServer;
	HList* m_pClients;
	HGarbageCollector* m_pGarbColl;
	
	HIDAcme* m_pDevice;
};

#endif // !defined(AFX_HIDSOCKET_H__5517669B_1125_4FD4_AB2D_E421415083B3__INCLUDED_)
