#pragma once

#define IR_UNKNOWN	0
#define IR_RC5		1

struct RC5Struct
{
	int		nState;
	int		bBitsCount;
	char	bBits[14];
	unsigned long ulTimestamp;
};

class CIRDecoder
{
public:
	CIRDecoder(int type);
	~CIRDecoder(void);

	const int getDecodeType(){return m_nType;};
	int decodeIR(unsigned char* buff, int len);

protected:
	void resetRC5();
	void addRc5Bit(char bit);
	bool checkOneRc5Pulse(short pulse);
	int decodeRC5(unsigned char* buff, int len);

	int m_nType;

	RC5Struct m_rc5;
};
