// stdafx.cpp : source file that includes just the standard includes
//	HIDDaemon.pch will be the pre-compiled header
//	stdafx.obj will contain the pre-compiled type information

#include "stdafx.h"

#ifdef _WIN32
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}
#endif

int g_nDbg = 0;

void SetDbgLevel(int dbg)
{
	g_nDbg = dbg;
}

int  GetDbgLevel()
{
	return g_nDbg;
}

void MyTrace(int dbg, const char * lpszFormat,...)
{
	if (dbg <= g_nDbg)
	{
		va_list args;
		va_start(args, lpszFormat);
		
		vprintf(lpszFormat, args);

		va_end(args);
	}
}

long getno(char* no)
{
	if (!no) return 0;
	if (no[0] == 0) return 0;

	if (no[0] == 'x') return strtol(no+1, NULL, 16);
	else return strtol(no, NULL, 10);
}

long getno(char *s, int base)
{
	return strtol( s, NULL, base );
}

int convertslash(char* buf)
{
	if (!buf) return 0;
	if (buf[0] == 0) return 0;

	int len = strlen(buf);
	char* temp = new char[len+1];

	strcpy(temp, buf);

	int cnt_temp = 0;
	int cnt_buf = 0;

	while (cnt_temp < len)
	{
		if (temp[cnt_temp] != '\\')
		{
			buf[cnt_buf++] = temp[cnt_temp];
			cnt_temp ++;
		}
		else
		{
			switch (temp[cnt_temp+1])
			{
			case '\\':buf[cnt_buf++] = '\\';break;
			case '0':buf[cnt_buf++] = 0;break;
			case '1':buf[cnt_buf++] = 1;break;
			case '2':buf[cnt_buf++] = 2;break;
			case '3':buf[cnt_buf++] = 3;break;
			case '4':buf[cnt_buf++] = 4;break;
			case '5':buf[cnt_buf++] = 5;break;
			case '6':buf[cnt_buf++] = 6;break;
			case '7':buf[cnt_buf++] = 7;break;
			case '8':buf[cnt_buf++] = 8;break;
			case '9':buf[cnt_buf++] = 9;break;
			/*case 'n':buf[cnt_buf++] = '\n';break;
			case 'r':buf[cnt_buf++] = '\r';break;
			case 't':buf[cnt_buf++] = '\t';break;*/
			default:buf[cnt_buf++] = temp[cnt_temp+1];
			}
			cnt_temp += 2;
		}
	}

	buf[cnt_buf] = 0;

	delete temp;

	return cnt_buf;
}


