#include "stdafx.h"

#ifndef _WIN32
#include <errno.h>
#endif

#include "HSocket.h"

bool HSocket::m_initialized = false;

#ifdef _WIN32
#else 
    #define FAR 
#endif 


HSocket::HSocket(const char* strIP,unsigned int port)
{
	m_socket = INVALID_SOCKET;
	m_status = 0;

	m_myPort=port;
	if (strIP)
	{
		m_myIP=new char[strlen(strIP)+1];
		strcpy(m_myIP,strIP);	
	}
	else m_myIP = NULL;
};

HSocket::HSocket( SOCKET sock, const char* strIP, unsigned int port)
{
	m_socket = sock;
	m_status = 0;

	m_myPort=port;
	if (strIP)
	{
		m_myIP=new char[strlen(strIP)+1];
		strcpy(m_myIP,strIP);	
	}
	else m_myIP = NULL;
}

HSocket::~HSocket()
{
	setStatus( -1 );

	if (m_myIP)
	{
		delete m_myIP;
		m_myIP=NULL;
	}
}

int HSocket::getData (char *buffer, int bufferSize)
{
	int readed, total = 0,nRecvLen= sizeof (destrecv_sin);

	while (total < bufferSize)
	{
		if ((readed = getStatus ()) < 0)
		{
			return readed;
		}
		readed = recv( m_socket, &buffer[total], bufferSize - total, MSG_NOSIGNAL|MSG_WAITALL );

		if ((readed == 0) || (readed == SOCKET_ERROR))
		{
#ifdef _WIN32
			if ((readed == SOCKET_ERROR) && (WSAGetLastError () == WSAEWOULDBLOCK))
#else			
			if ((readed == SOCKET_ERROR) && (errno == EAGAIN))
#endif
			
			{			
			    readed = 0;
			    Sleep (10);
			}
			else		
			{
#ifdef _WIN32
				int wsa_err  = WSAGetLastError();
				int sock_err = -1;int elen = sizeof(int);
				getsockopt(m_socket, SOL_SOCKET, SO_ERROR, (char*)&sock_err, &elen);

				MyTrace(1, "Socket error read: %d(%d) - socket closed [%s=%d]\n",wsa_err,sock_err,m_myIP,m_myPort);
#endif
			    setStatus (-1);
			    return -1;
			}
		}
		total += readed;
	}
	return total;
}
int HSocket::getLine( char *buffer, int bufferSize )
{
	int i = 0, readed;
	char c;

	while( i < bufferSize )
	{
		readed = getData( &c, sizeof(char) );
		if( readed < 0 )
		{
			buffer[0] = '\0';
			return readed;
		}
		if( (c == '\r') || (c == '\n') || (c == 0) )
		{
			break;
		}
		buffer[i] = c;
		i++;
	}
	buffer[i] = '\0';
	return i;
}

int HSocket::getStatus( void )
{
	if( m_socket == INVALID_SOCKET )
	{
		return -1;
	}
	return m_status;
}

int HSocket::sendData( const char *buffer, int bufferSize )
{
	int sended, total = 0;			
	if( bufferSize == 0 )
	{
		return getStatus();
	}

	while( total < bufferSize )
	{
		if( (sended = getStatus ()) < 0 )
		{
			return sended;
		}

		sended = send( m_socket, &buffer[total], bufferSize - total, MSG_NOSIGNAL );
		
		if( (sended == 0) || (sended == SOCKET_ERROR) )
		{
#ifdef _WIN32
			if( (sended == SOCKET_ERROR) && (WSAGetLastError () == WSAEWOULDBLOCK) )
#else			
			if( (sended == SOCKET_ERROR) && (errno == EAGAIN) )
#endif
			{
			    sended = 0;
			    Sleep( 2 );
			}
			else
			{
				//DWORD dw=GetLastError();
#ifdef _WIN32
				int wsa_err  = WSAGetLastError();
				int sock_err = -1;int elen = sizeof(int);
				getsockopt(m_socket, SOL_SOCKET, SO_ERROR, (char*)&sock_err, &elen);

				MyTrace(1, "Socket error write: %d(%d) - socket closed [%s=%d]",wsa_err,sock_err,m_myIP,m_myPort);
#endif

			    setStatus( -1 );
			    return -1;
			}
		}
		total += sended;
//		_tprintf("@(%d>%d) ",sended,total);
	}
	
//	_tprintf("E\n");

	return total;
}

void HSocket::setStatus( int status )
{
	if( m_status < 0 )
	{
		return;
	}

	if (status < 0) 
		MyTrace(1, "  Socket setting status  %d for [%s=%d]\n",status,m_myIP,m_myPort);

	m_status = status;

	if( (status < 0) && (m_socket != INVALID_SOCKET) )
	{
#ifdef _WIN32
//		shutdown (m_socket, SD_BOTH);
		closesocket( m_socket );
#else
		shutdown( m_socket, SHUT_RDWR );
		close( m_socket );
#endif		
		m_socket = INVALID_SOCKET;
	}
}

void HSocket::setSocket( SOCKET sock )
{
	m_socket = sock;
	m_status = 0;
}

void HSocket::setMode( )
{
	if (m_socket == INVALID_SOCKET) return;

#ifndef BLOCKING
	unsigned long param=1;
#ifdef _WIN32
	int nret = ioctlsocket(m_socket,FIONBIO,&param);	//set socket to nonblocking
#else
	int nret = ioctl(m_socket,FIONBIO,&param);
#endif
	if (nret!=0)
	{
#ifdef _WIN32
		int errorcode = WSAGetLastError();
#else
		int errorcode = -1;
#endif
		MyTrace(1, "  Socket setting nonblocking for [%s=%d] - ioctlsocket=%d (err=%d)\n",nret,errorcode,m_myIP,m_myPort);
	}
	else 
		MyTrace(1, "  Socket setting nonblocking for [%s=%d] - OK\n", m_myIP,m_myPort);
#endif
}

void HSocket::flush( void )
{
#ifdef _LINUX
	ioctl( m_socket, I_FLUSH, FLUSHRW );
#endif
}

bool HSocket::SetInBufLen(int nLen)
{
	int i = setsockopt(m_socket,SOL_SOCKET,SO_RCVBUF,(char*)&nLen,sizeof(nLen));

	if (i!=0) MyTrace(1, "Set sock in buf len %d failed\n",nLen);
	else MyTrace(1, "Set sock in buf len %d OK\n",nLen);

	return (i!=0);
}

bool HSocket::SetOutBufLen(int nLen)
{
	int i = setsockopt(m_socket,SOL_SOCKET,SO_SNDBUF,(char*)&nLen,sizeof(nLen));

	if (i!=0) MyTrace(1, "Set sock out buf len %d failed\n",nLen);
	else MyTrace(1, "Set sock out buf len %d OK\n",nLen);

	return (i!=0);
}

bool HSocket::initSocketLibrary( unsigned int VerMajor,unsigned int VerMinor)
{
#ifdef _WIN32
	if( !m_initialized )
	{
		WORD socketVersionRequested;
		WSADATA wsaData;
		socketVersionRequested = MAKEWORD (VerMajor,VerMinor);
		if (WSAStartup (socketVersionRequested, &wsaData) != 0)
		{ 
			WSACleanup();
		}
		else
		{
			m_initialized = true;
		}
	}
#else
	m_initialized = true;
#endif
	return m_initialized;
}

void HSocket::closeSocketLibrary( void )
{
#ifdef _WIN32
	WSACleanup();
#endif
	m_initialized = false;
}

